/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.slack.util;

import com.slack.api.methods.MethodsClient;
import com.slack.api.methods.SlackApiException;
import com.slack.api.methods.request.conversations.ConversationsListRequest;
import com.slack.api.methods.response.conversations.ConversationsListResponse;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.nifi.processors.slack.PublishSlack;
import org.apache.nifi.util.StringUtils;

public class ChannelMapper {
    private final Map<String, String> mappedChannels = new ConcurrentHashMap<String, String>();
    private final MethodsClient client;

    public ChannelMapper(MethodsClient client) {
        this.client = client;
    }

    public String lookupChannelId(String channelName) throws SlackApiException, IOException {
        String channelId;
        if (channelName == null) {
            return null;
        }
        if ((channelName = channelName.trim()).startsWith("#")) {
            if (channelName.length() == 1) {
                return null;
            }
            channelName = channelName.substring(1);
        }
        if ((channelId = this.mappedChannels.get(channelName)) == null) {
            this.lookupChannels(channelName);
        }
        return this.mappedChannels.get(channelName);
    }

    private void lookupChannels(String desiredChannelName) throws SlackApiException, IOException {
        ConversationsListRequest request;
        ConversationsListResponse response;
        String cursor = null;
        while ((response = this.client.conversationsList(request = ConversationsListRequest.builder().cursor(cursor).limit(Integer.valueOf(1000)).build())).isOk()) {
            response.getChannels().forEach(channel -> this.mappedChannels.put(channel.getName(), channel.getId()));
            cursor = response.getResponseMetadata().getNextCursor();
            if (StringUtils.isEmpty((String)cursor)) {
                return;
            }
            if (!this.mappedChannels.containsKey(desiredChannelName)) continue;
            return;
        }
        String errorMessage = PublishSlack.getErrorMessage(response.getError(), response.getNeeded(), response.getProvided(), response.getWarning());
        throw new RuntimeException("Failed to determine Channel IDs: " + errorMessage);
    }
}

