/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.single.user;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.apache.nifi.authentication.single.user.SingleUserLoginIdentityProvider;
import org.apache.nifi.authorization.AuthorizationRequest;
import org.apache.nifi.authorization.AuthorizationResult;
import org.apache.nifi.authorization.Authorizer;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.AuthorizerInitializationContext;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.xml.processing.stream.StandardXMLEventReaderProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleUserAuthorizer
implements Authorizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleUserAuthorizer.class);
    private static final String REQUIRED_PROVIDER = SingleUserLoginIdentityProvider.class.getName();
    private static final String IDENTIFIER_TAG = "identifier";
    private static final String CLASS_TAG = "class";
    private static final String BLANK_PROVIDER = "provider";
    private NiFiProperties niFiProperties;

    @AuthorizerContext
    public void setProperties(NiFiProperties niFiProperties) {
        this.niFiProperties = niFiProperties;
    }

    public AuthorizationResult authorize(AuthorizationRequest request) throws AuthorizationAccessException {
        return AuthorizationResult.approved();
    }

    public void initialize(AuthorizerInitializationContext initializationContext) {
        LOGGER.info("Initializing Authorizer");
        String securityUserAuthorizer = this.niFiProperties.getProperty("nifi.security.user.authorizer");
        String authorizerIdentifier = initializationContext.getIdentifier();
        if (authorizerIdentifier.equals(securityUserAuthorizer)) {
            File configuration = this.niFiProperties.getLoginIdentityProviderConfigurationFile();
            String identifier = this.niFiProperties.getProperty("nifi.security.user.login.identity.provider", BLANK_PROVIDER);
            if (this.isSingleUserLoginIdentityProviderConfigured(identifier, configuration)) {
                LOGGER.debug("Required Login Identity Provider Configured [{}]", (Object)REQUIRED_PROVIDER);
            } else {
                String message = String.format("%s requires %s to be configured", this.getClass().getSimpleName(), REQUIRED_PROVIDER);
                throw new AuthorizerCreationException(message);
            }
        }
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) {
        LOGGER.info("Configuring Authorizer");
    }

    public void preDestruction() {
        LOGGER.info("Destroying Authorizer");
    }

    private boolean isSingleUserLoginIdentityProviderConfigured(String configuredIdentifier, File configuration) {
        boolean bl;
        FileInputStream inputStream = new FileInputStream(configuration);
        try {
            XMLEventReader reader = this.getProvidersReader(inputStream);
            boolean configured = this.isSingleUserLoginIdentityProviderConfigured(configuredIdentifier, reader);
            reader.close();
            bl = configured;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | XMLStreamException e) {
                throw new AuthorizerCreationException("Failed to read Login Identity Providers Configuration", (Throwable)e);
            }
        }
        ((InputStream)inputStream).close();
        return bl;
    }

    private boolean isSingleUserLoginIdentityProviderConfigured(String configuredIdentifier, XMLEventReader reader) throws XMLStreamException {
        boolean providerConfigured = false;
        boolean identifierFound = false;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (this.isStartElement(event, IDENTIFIER_TAG)) {
                String providerIdentifier = reader.getElementText().trim();
                identifierFound = configuredIdentifier.equals(providerIdentifier);
            }
            if (!identifierFound || !this.isStartElement(event, CLASS_TAG)) continue;
            String providerClass = reader.getElementText().trim();
            providerConfigured = REQUIRED_PROVIDER.equals(providerClass);
        }
        return providerConfigured;
    }

    private boolean isStartElement(XMLEvent event, String localElementName) {
        boolean found = false;
        if (event.isStartElement()) {
            StartElement startElement = event.asStartElement();
            found = localElementName.equals(startElement.getName().getLocalPart());
        }
        return found;
    }

    private XMLEventReader getProvidersReader(InputStream inputStream) throws XMLStreamException {
        StandardXMLEventReaderProvider readerProvider = new StandardXMLEventReaderProvider();
        return readerProvider.getEventReader(new StreamSource(inputStream));
    }
}

