/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.util.IdentityMapping;
import org.apache.nifi.util.NiFiProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IdentityMappingUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityMappingUtil.class);
    private static final Pattern backReferencePattern = Pattern.compile("\\$(\\d+)");

    public static List<IdentityMapping> getIdentityMappings(NiFiProperties properties) {
        return IdentityMappingUtil.getMappings(properties, "nifi.security.identity.mapping.pattern.", "nifi.security.identity.mapping.value.", "nifi.security.identity.mapping.transform.", () -> "Identity");
    }

    public static List<IdentityMapping> getGroupMappings(NiFiProperties properties) {
        return IdentityMappingUtil.getMappings(properties, "nifi.security.group.mapping.pattern.", "nifi.security.group.mapping.value.", "nifi.security.group.mapping.transform.", () -> "Group");
    }

    private static List<IdentityMapping> getMappings(NiFiProperties properties, String patternPrefix, String valuePrefix, String transformPrefix, Supplier<String> getSubject) {
        ArrayList<IdentityMapping> mappings = new ArrayList<IdentityMapping>();
        for (String propertyName : properties.getPropertyKeys()) {
            IdentityMapping.Transform identityTransform;
            if (!StringUtils.startsWith((CharSequence)propertyName, (CharSequence)patternPrefix)) continue;
            String key = StringUtils.substringAfter((String)propertyName, (String)patternPrefix);
            String identityPattern = properties.getProperty(propertyName);
            if (StringUtils.isBlank((CharSequence)identityPattern)) {
                LOGGER.warn("{} Mapping property {} was found, but was empty", new Object[]{getSubject.get(), propertyName});
                continue;
            }
            String identityValueProperty = valuePrefix + key;
            String identityValue = properties.getProperty(identityValueProperty);
            if (StringUtils.isBlank((CharSequence)identityValue)) {
                LOGGER.warn("{} Mapping property {} was found, but corresponding value {} was not found", new Object[]{getSubject.get(), propertyName, identityValueProperty});
                continue;
            }
            String identityTransformProperty = transformPrefix + key;
            String rawIdentityTransform = properties.getProperty(identityTransformProperty);
            if (StringUtils.isBlank((CharSequence)rawIdentityTransform)) {
                LOGGER.debug("{} Mapping property {} was found, but no transform was present. Using NONE.", new Object[]{getSubject.get(), propertyName});
                rawIdentityTransform = IdentityMapping.Transform.NONE.name();
            }
            try {
                identityTransform = IdentityMapping.Transform.valueOf(rawIdentityTransform);
            }
            catch (IllegalArgumentException iae) {
                LOGGER.warn("{} Mapping property {} was found, but corresponding transform {} was not valid. Allowed values {}", new Object[]{getSubject.get(), propertyName, rawIdentityTransform, StringUtils.join((Object[])IdentityMapping.Transform.values(), (String)", ")});
                continue;
            }
            IdentityMapping identityMapping = new IdentityMapping(key, Pattern.compile(identityPattern), identityValue, identityTransform);
            mappings.add(identityMapping);
            LOGGER.debug("Found {} Mapping with key = {}, pattern = {}, value = {}, transform = {}", new Object[]{getSubject.get(), key, identityPattern, identityValue, rawIdentityTransform});
        }
        Collections.sort(mappings, new Comparator<IdentityMapping>(){

            @Override
            public int compare(IdentityMapping m1, IdentityMapping m2) {
                return m1.getKey().compareTo(m2.getKey());
            }
        });
        return mappings;
    }

    public static String mapIdentity(String identity, List<IdentityMapping> mappings) {
        for (IdentityMapping mapping : mappings) {
            Matcher m = mapping.getPattern().matcher(identity);
            if (!m.matches()) continue;
            String pattern = mapping.getPattern().pattern();
            String replacementValue = IdentityMappingUtil.escapeLiteralBackReferences(mapping.getReplacementValue(), m.groupCount());
            String replacement = identity.replaceAll(pattern, replacementValue);
            if (IdentityMapping.Transform.UPPER.equals((Object)mapping.getTransform())) {
                return replacement.toUpperCase();
            }
            if (IdentityMapping.Transform.LOWER.equals((Object)mapping.getTransform())) {
                return replacement.toLowerCase();
            }
            return replacement;
        }
        return identity;
    }

    private static String escapeLiteralBackReferences(String unescaped, int numCapturingGroups) {
        if (numCapturingGroups == 0) {
            return unescaped;
        }
        String value = unescaped;
        Matcher backRefMatcher = backReferencePattern.matcher(value);
        while (backRefMatcher.find()) {
            int originalBackRefIndex;
            int backRefIndex;
            String backRefNum = backRefMatcher.group(1);
            if (backRefNum.startsWith("0")) continue;
            for (backRefIndex = originalBackRefIndex = Integer.parseInt(backRefNum); backRefIndex > numCapturingGroups && backRefIndex >= 10; backRefIndex /= 10) {
            }
            if (backRefIndex <= numCapturingGroups) continue;
            StringBuilder sb = new StringBuilder(value.length() + 1);
            int groupStart = backRefMatcher.start(1);
            sb.append(value.substring(0, groupStart - 1));
            sb.append("\\");
            sb.append(value.substring(groupStart - 1));
            value = sb.toString();
        }
        return value;
    }
}

