/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.kms.reader;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Path;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.nifi.security.kms.reader.FileBasedKeyReader;
import org.apache.nifi.security.kms.reader.KeyReaderException;

public class StandardFileBasedKeyReader
implements FileBasedKeyReader {
    protected static final String CIPHER_ALGORITHM = "AES/GCM/NoPadding";
    protected static final int IV_LENGTH_BYTES = 16;
    protected static final int TAG_SIZE_BITS = 128;
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private static final String SECRET_KEY_ALGORITHM = "AES";

    @Override
    public Map<String, SecretKey> readSecretKeys(Path path, SecretKey rootKey) {
        Objects.requireNonNull(path, "Path required");
        Objects.requireNonNull(rootKey, "Root Key required");
        HashMap<String, SecretKey> secretKeys = new HashMap<String, SecretKey>();
        Properties properties = this.getProperties(path);
        for (String keyId : properties.stringPropertyNames()) {
            String encodedProperty = properties.getProperty(keyId);
            SecretKey secretKey = this.readSecretKey(keyId, encodedProperty, rootKey);
            secretKeys.put(keyId, secretKey);
        }
        return secretKeys;
    }

    private Properties getProperties(Path path) {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            properties.load(inputStream);
        }
        catch (IOException e) {
            throw new KeyReaderException(String.format("Reading Secret Keys Failed [%s]", path), e);
        }
        return properties;
    }

    private SecretKey readSecretKey(String keyId, String encodedProperty, SecretKey rootKey) {
        byte[] encryptedProperty = DECODER.decode(encodedProperty);
        Cipher cipher = this.getCipher(keyId, encryptedProperty, rootKey);
        byte[] encryptedSecretKey = Arrays.copyOfRange(encryptedProperty, 16, encryptedProperty.length);
        try {
            byte[] secretKey = cipher.doFinal(encryptedSecretKey);
            return new SecretKeySpec(secretKey, SECRET_KEY_ALGORITHM);
        }
        catch (BadPaddingException | IllegalBlockSizeException e) {
            throw new KeyReaderException(String.format("Key Identifier [%s] decryption failed", keyId), e);
        }
    }

    private Cipher getCipher(String keyId, byte[] encryptedProperty, SecretKey rootKey) {
        byte[] initializationVector = Arrays.copyOfRange(encryptedProperty, 0, 16);
        Cipher cipher = this.getCipher();
        try {
            cipher.init(2, (Key)rootKey, new GCMParameterSpec(128, initializationVector));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException e) {
            throw new KeyReaderException(String.format("Cipher initialization failed for Key Identifier [%s]", keyId), e);
        }
        return cipher;
    }

    private Cipher getCipher() {
        try {
            return Cipher.getInstance(CIPHER_ALGORITHM);
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new KeyReaderException(String.format("Cipher Algorithm [%s] initialization failed", CIPHER_ALGORITHM), e);
        }
    }
}

