/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.bcrypt;

import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.security.crypto.key.DerivedKeyParameterSpecReader;
import org.apache.nifi.security.crypto.key.bcrypt.BcryptBase64Decoder;
import org.apache.nifi.security.crypto.key.bcrypt.BcryptDerivedKeyParameterSpec;

public class BcryptDerivedKeyParameterSpecReader
implements DerivedKeyParameterSpecReader<BcryptDerivedKeyParameterSpec> {
    private static final Pattern MODULAR_CRYPT_FORMAT = Pattern.compile("^\\$2[abxy]\\$(\\d{2})\\$([\\w/.]{22})([\\w/.]{31})?$");
    private static final int COST_GROUP = 1;
    private static final int SALT_GROUP = 2;
    private static final Charset PARAMETERS_CHARACTER_SET = StandardCharsets.US_ASCII;

    @Override
    public BcryptDerivedKeyParameterSpec read(byte[] serializedParameters) {
        Objects.requireNonNull(serializedParameters, "Parameters required");
        String parameters = new String(serializedParameters, PARAMETERS_CHARACTER_SET);
        Matcher matcher = MODULAR_CRYPT_FORMAT.matcher(parameters);
        if (matcher.matches()) {
            String costGroup = matcher.group(1);
            String saltGroup = matcher.group(2);
            int cost = Integer.parseInt(costGroup);
            byte[] salt = BcryptBase64Decoder.decode(saltGroup);
            return new BcryptDerivedKeyParameterSpec(cost, salt);
        }
        String message = String.format("bcrypt serialized parameters [%s] format not matched", parameters);
        throw new IllegalArgumentException(message);
    }
}

