/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.crypto.key.argon2;

import java.util.Base64;
import org.apache.nifi.security.crypto.key.DerivedKey;
import org.apache.nifi.security.crypto.key.DerivedKeyProvider;
import org.apache.nifi.security.crypto.key.DerivedKeySpec;
import org.apache.nifi.security.crypto.key.DerivedSecretKey;
import org.apache.nifi.security.crypto.key.argon2.Argon2DerivedKeyParameterSpec;
import org.bouncycastle.shaded.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.shaded.crypto.params.Argon2Parameters;

public class Argon2DerivedKeyProvider
implements DerivedKeyProvider<Argon2DerivedKeyParameterSpec> {
    private static final int HYBRID_VERSION = 2;
    private static final int CURRENT_VERSION = 19;
    private static final String SERIALIZED_FORMAT = "$argon2id$v=%d$m=%d,t=%d,p=%d$%s$%s";
    private static final Base64.Encoder encoder = Base64.getEncoder().withoutPadding();

    @Override
    public DerivedKey getDerivedKey(DerivedKeySpec<Argon2DerivedKeyParameterSpec> derivedKeySpec) {
        Argon2DerivedKeyParameterSpec parameterSpec = derivedKeySpec.getParameterSpec();
        Argon2Parameters parameters = this.getParameters(parameterSpec);
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(parameters);
        int derivedKeyLength = derivedKeySpec.getDerivedKeyLength();
        byte[] derivedKeyBytes = new byte[derivedKeyLength];
        char[] password = derivedKeySpec.getPassword();
        generator.generateBytes(password, derivedKeyBytes);
        String serialized = this.getSerialized(derivedKeyBytes, parameterSpec);
        return new DerivedSecretKey(derivedKeyBytes, derivedKeySpec.getAlgorithm(), serialized);
    }

    private Argon2Parameters getParameters(Argon2DerivedKeyParameterSpec parameterSpec) {
        return new Argon2Parameters.Builder(2).withVersion(19).withMemoryAsKB(parameterSpec.getMemory()).withIterations(parameterSpec.getIterations()).withParallelism(parameterSpec.getParallelism()).withSalt(parameterSpec.getSalt()).build();
    }

    private String getSerialized(byte[] derivedKeyBytes, Argon2DerivedKeyParameterSpec parameterSpec) {
        String derivedKeyEncoded = encoder.encodeToString(derivedKeyBytes);
        String saltEncoded = encoder.encodeToString(parameterSpec.getSalt());
        return String.format(SERIALIZED_FORMAT, 19, parameterSpec.getMemory(), parameterSpec.getIterations(), parameterSpec.getParallelism(), saltEncoded, derivedKeyEncoded);
    }
}

