/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.script;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.search.SearchContext;
import org.apache.nifi.search.SearchResult;

public class ScriptingComponentUtils {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles that were successfully processed").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("FlowFiles that failed to be processed").build();
    public static final PropertyDescriptor SCRIPT_FILE = new PropertyDescriptor.Builder().name("Script File").required(false).description("Path to script file to execute. Only one of Script File or Script Body may be used").identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor SCRIPT_BODY = new PropertyDescriptor.Builder().name("Script Body").required(false).description("Body of script to execute. Only one of Script File or Script Body may be used").addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.NONE).build();
    public static final PropertyDescriptor MODULES = new PropertyDescriptor.Builder().name("Module Directory").description("Comma-separated list of paths to files and/or directories which contain modules required by the script.").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.DIRECTORY}).build();

    public static Collection<SearchResult> search(SearchContext context, ComponentLog logger) {
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        String term = context.getSearchTerm();
        ResourceReference scriptFile = context.getProperty(SCRIPT_FILE).evaluateAttributeExpressions().asResource();
        String script = context.getProperty(SCRIPT_BODY).getValue();
        if (StringUtils.isBlank((CharSequence)script) && scriptFile == null) {
            return results;
        }
        if (StringUtils.isBlank((CharSequence)script)) {
            try (InputStream in = scriptFile.read();){
                script = IOUtils.toString((InputStream)in, (Charset)StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                logger.error(String.format("Could not read from path %s", scriptFile), (Throwable)e);
                return results;
            }
        }
        Scanner scanner = new Scanner(script);
        int index = 1;
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            if (StringUtils.containsIgnoreCase((CharSequence)line, (CharSequence)term)) {
                String text = String.format("Matched script at line %d: %s", index, line);
                results.add(new SearchResult.Builder().label(text).match(term).build());
            }
            ++index;
        }
        return results;
    }

    public static Set<String> getAvailableEngines() {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        List<ScriptEngineFactory> scriptEngineFactories = scriptEngineManager.getEngineFactories();
        TreeSet<String> engines = new TreeSet<String>();
        for (ScriptEngineFactory factory : scriptEngineFactories) {
            engines.add(factory.getLanguageName());
        }
        return engines;
    }
}

