/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.script;

import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.script.ScriptEvaluator;
import org.apache.nifi.processors.script.ScriptedTransformRecord;
import org.apache.nifi.serialization.record.Record;

class InterpretedScriptEvaluator
implements ScriptEvaluator {
    private final ScriptEngine scriptEngine;
    private final String scriptToRun;
    private final Bindings bindings;

    InterpretedScriptEvaluator(ScriptEngine scriptEngine, String scriptToRun, FlowFile flowFile, ComponentLog logger) {
        this.scriptEngine = scriptEngine;
        this.scriptToRun = scriptToRun;
        this.bindings = ScriptedTransformRecord.setupBindings(scriptEngine);
        this.bindings.put("attributes", (Object)flowFile.getAttributes());
        this.bindings.put("log", (Object)logger);
    }

    @Override
    public Object evaluate(Record record, long index) throws ScriptException {
        this.bindings.put("record", (Object)record);
        this.bindings.put("recordIndex", (Object)index);
        return this.scriptEngine.eval(this.scriptToRun, this.bindings);
    }
}

