/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.repository.schema;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.repository.schema.FieldCache;
import org.apache.nifi.repository.schema.FieldMapRecord;
import org.apache.nifi.repository.schema.FieldType;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordField;
import org.apache.nifi.repository.schema.RecordIterator;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.SingleRecordIterator;

public class SchemaRecordReader {
    private final RecordSchema schema;
    private final FieldCache fieldCache;

    private SchemaRecordReader(RecordSchema schema, FieldCache fieldCache) {
        this.schema = schema;
        this.fieldCache = fieldCache;
    }

    public static SchemaRecordReader fromSchema(RecordSchema schema, FieldCache fieldCache) {
        return new SchemaRecordReader(schema, fieldCache);
    }

    private static void fillBuffer(InputStream in, byte[] destination) throws IOException {
        int len;
        for (int bytesRead = 0; bytesRead < destination.length; bytesRead += len) {
            len = in.read(destination, bytesRead, destination.length - bytesRead);
            if (len >= 0) continue;
            throw new EOFException();
        }
    }

    public Record readRecord(InputStream in) throws IOException {
        int recordIndicator = in.read();
        if (recordIndicator < 0) {
            return null;
        }
        if (recordIndicator == 8) {
            throw new IOException("Expected to read a Sentinel Byte of '1' indicating that the next record is inline but the Sentinel value was '8, indicating that data was written to an External File. This data cannot be recovered via calls to #readRecord(InputStream) but must be recovered via #readRecords(InputStream)");
        }
        if (recordIndicator != 1) {
            throw new IOException("Expected to read a Sentinel Byte of '1' but got a value of '" + recordIndicator + "' instead");
        }
        return this.readInlineRecord(in);
    }

    private Record readInlineRecord(InputStream in) throws IOException {
        List<RecordField> schemaFields = this.schema.getFields();
        HashMap<RecordField, Object> fields = new HashMap<RecordField, Object>(schemaFields.size());
        for (RecordField field : this.schema.getFields()) {
            Object value = this.readField(in, field);
            fields.put(field, value);
        }
        return new FieldMapRecord(fields, this.schema);
    }

    public RecordIterator readRecords(InputStream in) throws IOException {
        int recordIndicator = in.read();
        if (recordIndicator < 0) {
            return null;
        }
        if (recordIndicator == 1) {
            Record nextRecord = this.readInlineRecord(in);
            return new SingleRecordIterator(nextRecord);
        }
        if (recordIndicator != 8) {
            throw new IOException("Expected to read a Sentinel Byte of '1' or '8' but encountered a value of '" + recordIndicator + "' instead");
        }
        DataInputStream dis = new DataInputStream(in);
        String externalFilename = dis.readUTF();
        File externalFile = new File(externalFilename);
        FileInputStream fis = new FileInputStream(externalFile);
        final BufferedInputStream bufferedIn = new BufferedInputStream(fis);
        RecordIterator recordIterator = new RecordIterator(){

            @Override
            public Record next() throws IOException {
                return SchemaRecordReader.this.readRecord(bufferedIn);
            }

            @Override
            public boolean isNext() throws IOException {
                bufferedIn.mark(1);
                int nextByte = bufferedIn.read();
                bufferedIn.reset();
                return nextByte > -1;
            }

            @Override
            public void close() throws IOException {
                bufferedIn.close();
            }
        };
        return recordIterator;
    }

    private Object readField(InputStream in, RecordField field) throws IOException {
        switch (field.getRepetition()) {
            case ZERO_OR_MORE: {
                int iterations = this.readInt(in);
                if (iterations == 0) {
                    return Collections.emptyList();
                }
                ArrayList<Object> value = new ArrayList<Object>(iterations);
                for (int i = 0; i < iterations; ++i) {
                    value.add(this.readFieldValue(in, field.getFieldType(), field.getFieldName(), field.getSubFields()));
                }
                return value;
            }
            case ZERO_OR_ONE: {
                int nextByte = in.read();
                if (nextByte == -1) {
                    throw new EOFException("Unexpected End-of-File when attempting to read Repetition value for field '" + field.getFieldName() + "'");
                }
                if (nextByte == 0) {
                    return null;
                }
                if (nextByte == 1) break;
                throw new IOException("Invalid Boolean value found when reading 'Repetition' of field '" + field.getFieldName() + "'. Expected 0 or 1 but got " + (nextByte & 0xFF));
            }
        }
        try {
            return this.readFieldValue(in, field.getFieldType(), field.getFieldName(), field.getSubFields());
        }
        catch (EOFException eof) {
            EOFException exception = new EOFException("Failed to read field '" + field.getFieldName() + "'");
            exception.addSuppressed(eof);
            throw exception;
        }
        catch (IOException ioe) {
            throw new IOException("Failed to read field '" + field.getFieldName() + "'", ioe);
        }
    }

    private Object readFieldValue(InputStream in, FieldType fieldType, String fieldName, List<RecordField> subFields) throws IOException {
        switch (fieldType) {
            case BOOLEAN: {
                DataInputStream dis = new DataInputStream(in);
                return dis.readBoolean();
            }
            case INT: {
                return this.readInt(in);
            }
            case LONG: {
                DataInputStream dis = new DataInputStream(in);
                return dis.readLong();
            }
            case STRING: {
                DataInputStream dis = new DataInputStream(in);
                String value = dis.readUTF();
                return this.fieldCache.cache(value);
            }
            case LONG_STRING: {
                int length = this.readInt(in);
                byte[] buffer = new byte[length];
                SchemaRecordReader.fillBuffer(in, buffer);
                String value = new String(buffer, StandardCharsets.UTF_8);
                return this.fieldCache.cache(value);
            }
            case BYTE_ARRAY: {
                int length = this.readInt(in);
                byte[] buffer = new byte[length];
                SchemaRecordReader.fillBuffer(in, buffer);
                return buffer;
            }
            case MAP: {
                int numEntries = this.readInt(in);
                RecordField keyField = subFields.get(0);
                RecordField valueField = subFields.get(1);
                HashMap<Object, Object> entries = new HashMap<Object, Object>(numEntries);
                for (int i = 0; i < numEntries; ++i) {
                    Object key = this.readField(in, keyField);
                    Object value = this.readField(in, valueField);
                    entries.put(key, value);
                }
                return entries;
            }
            case COMPLEX: {
                int numSubFields = subFields.size();
                HashMap<RecordField, Object> subFieldValues = new HashMap<RecordField, Object>(numSubFields);
                for (int i = 0; i < numSubFields; ++i) {
                    Object subFieldValue = this.readField(in, subFields.get(i));
                    subFieldValues.put(subFields.get(i), subFieldValue);
                }
                return new FieldMapRecord(subFieldValues, new RecordSchema(subFields));
            }
            case UNION: {
                DataInputStream dis = new DataInputStream(in);
                String childFieldType = dis.readUTF();
                Optional<RecordField> fieldOption = subFields.stream().filter(field -> field.getFieldName().equals(childFieldType)).findFirst();
                if (!fieldOption.isPresent()) {
                    throw new IOException("Found a field of type '" + childFieldType + "' but that was not in the expected list of types");
                }
                RecordField matchingField = fieldOption.get();
                return this.readField(in, matchingField);
            }
        }
        throw new IOException("Unrecognized Field Type " + fieldType + " for field '" + fieldName + "'");
    }

    private int readInt(InputStream in) throws IOException {
        byte[] buffer = new byte[4];
        SchemaRecordReader.fillBuffer(in, buffer);
        return ByteBuffer.wrap(buffer).getInt();
    }
}

