/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.schemaregistry.services;

import java.io.IOException;
import java.util.Set;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.deprecation.log.DeprecationLogger;
import org.apache.nifi.deprecation.log.DeprecationLoggerFactory;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public interface SchemaRegistry
extends ControllerService {
    default public String retrieveSchemaText(String schemaName) throws IOException, SchemaNotFoundException {
        DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(this.getClass());
        String deprecatedMethod = "retrieveSchemaText(schemaName)";
        String replacementMethod = "retrieveSchema(SchemaIdentifier)";
        deprecationLogger.warn("{}[id={}] {} should be replaced with {}", new Object[]{this.getClass().getSimpleName(), this.getIdentifier(), "retrieveSchemaText(schemaName)", "retrieveSchema(SchemaIdentifier)"});
        RecordSchema recordSchema = this.retrieveSchema(SchemaIdentifier.builder().name(schemaName).build());
        if (recordSchema == null) {
            throw new SchemaNotFoundException("Could not find schema with name '" + schemaName + "'");
        }
        return (String)recordSchema.getSchemaText().get();
    }

    default public String retrieveSchemaText(long schemaId, int version) throws IOException, SchemaNotFoundException {
        DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(this.getClass());
        String deprecatedMethod = "retrieveSchemaText(schemaId, version)";
        String replacementMethod = "retrieveSchema(SchemaIdentifier)";
        deprecationLogger.warn("{}[id={}] {} should be replaced with {}", new Object[]{this.getClass().getSimpleName(), this.getIdentifier(), "retrieveSchemaText(schemaId, version)", "retrieveSchema(SchemaIdentifier)"});
        RecordSchema recordSchema = this.retrieveSchema(SchemaIdentifier.builder().id(Long.valueOf(schemaId)).version(Integer.valueOf(version)).build());
        if (recordSchema == null) {
            throw new SchemaNotFoundException("Could not find schema with ID '" + schemaId + "' and version '" + version + "'");
        }
        return (String)recordSchema.getSchemaText().get();
    }

    default public RecordSchema retrieveSchema(String schemaName) throws IOException, SchemaNotFoundException {
        DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(this.getClass());
        String deprecatedMethod = "retrieveSchemaText(schemaName)";
        String replacementMethod = "retrieveSchema(SchemaIdentifier)";
        deprecationLogger.warn("{}[id={}] {} should be replaced with {}", new Object[]{this.getClass().getSimpleName(), this.getIdentifier(), "retrieveSchemaText(schemaName)", "retrieveSchema(SchemaIdentifier)"});
        return this.retrieveSchema(SchemaIdentifier.builder().name(schemaName).build());
    }

    default public RecordSchema retrieveSchema(long schemaId, int version) throws IOException, SchemaNotFoundException {
        DeprecationLogger deprecationLogger = DeprecationLoggerFactory.getLogger(this.getClass());
        String deprecatedMethod = "retrieveSchemaText(schemaId, version)";
        String replacementMethod = "retrieveSchema(SchemaIdentifier)";
        deprecationLogger.warn("{}[id={}] {} should be replaced with {}", new Object[]{this.getClass().getSimpleName(), this.getIdentifier(), "retrieveSchemaText(schemaId, version)", "retrieveSchema(SchemaIdentifier)"});
        return this.retrieveSchema(SchemaIdentifier.builder().id(Long.valueOf(schemaId)).version(Integer.valueOf(version)).build());
    }

    public RecordSchema retrieveSchema(SchemaIdentifier var1) throws IOException, SchemaNotFoundException;

    public Set<SchemaField> getSuppliedSchemaFields();
}

