/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.redis;

public enum RedisType {
    STANDALONE("Standalone", "A single standalone Redis instance."),
    SENTINEL("Sentinel", "Redis Sentinel which provides high-availability. Described further at https://redis.io/topics/sentinel"),
    CLUSTER("Cluster", "Clustered Redis which provides sharding and replication. Described further at https://redis.io/topics/cluster-spec");

    private final String displayName;
    private final String description;

    private RedisType(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public static RedisType fromDisplayName(String displayName) {
        for (RedisType redisType : RedisType.values()) {
            if (!redisType.getDisplayName().equals(displayName)) continue;
            return redisType;
        }
        throw new IllegalArgumentException("Unknown RedisType: " + displayName);
    }
}

