/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util.pattern;

import java.util.Collection;
import java.util.List;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.ProcessSessionFactory;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.pattern.RoutingResult;

public class PartialFunctions {
    public static <FCT> FetchFlowFiles<FCT> fetchSingleFlowFile() {
        return (context, session, functionContext, result) -> session.get(1);
    }

    public static <FCT> TransferFlowFiles<FCT> transferRoutedFlowFiles() {
        return (context, session, functionContext, result) -> result.getRoutedFlowFiles().forEach((relationship, routedFlowFiles) -> session.transfer((Collection)routedFlowFiles, relationship));
    }

    public static void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory, ComponentLog logger, OnTrigger onTrigger) throws ProcessException {
        PartialFunctions.onTrigger(context, sessionFactory, logger, onTrigger, (session, t) -> session.rollback(true));
    }

    public static void onTrigger(ProcessContext context, ProcessSessionFactory sessionFactory, ComponentLog logger, OnTrigger onTrigger, RollbackSession rollbackSession) throws ProcessException {
        ProcessSession session = sessionFactory.createSession();
        try {
            onTrigger.execute(session);
            session.commitAsync();
        }
        catch (Throwable t) {
            logger.error("{} failed to process; rolling back session", new Object[]{onTrigger, t});
            rollbackSession.rollback(session, t);
            throw t;
        }
    }

    @FunctionalInterface
    public static interface FetchFlowFiles<FC> {
        public List<FlowFile> apply(ProcessContext var1, ProcessSession var2, FC var3, RoutingResult var4) throws ProcessException;
    }

    @FunctionalInterface
    public static interface TransferFlowFiles<FC> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, RoutingResult var4) throws ProcessException;

        default public TransferFlowFiles<FC> andThen(TransferFlowFiles<FC> after) {
            return (context, session, functionContext, result) -> {
                this.apply(context, session, functionContext, result);
                after.apply(context, session, functionContext, result);
            };
        }
    }

    @FunctionalInterface
    public static interface RollbackSession {
        public void rollback(ProcessSession var1, Throwable var2);
    }

    @FunctionalInterface
    public static interface OnTrigger {
        public void execute(ProcessSession var1) throws ProcessException;
    }

    @FunctionalInterface
    public static interface AdjustFailed {
        public boolean apply(ProcessContext var1, RoutingResult var2);
    }

    @FunctionalInterface
    public static interface AdjustRoute<FC> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, RoutingResult var4) throws ProcessException;
    }

    @FunctionalInterface
    public static interface FlowFileGroup {
        public List<FlowFile> getFlowFiles();
    }

    @FunctionalInterface
    public static interface Cleanup<FC, C> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, C var4) throws ProcessException;
    }

    @FunctionalInterface
    public static interface OnFailed<FC, C> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, C var4, Exception var5) throws ProcessException;
    }

    @FunctionalInterface
    public static interface OnCompleted<FC, C> {
        public void apply(ProcessContext var1, ProcessSession var2, FC var3, C var4) throws ProcessException;
    }

    @FunctionalInterface
    public static interface InitConnection<FC, C> {
        public C apply(ProcessContext var1, ProcessSession var2, FC var3, List<FlowFile> var4) throws ProcessException;
    }
}

