/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.properties;

import java.util.Properties;
import org.apache.nifi.properties.ClientBasedEncodedSensitivePropertyProvider;
import org.apache.nifi.properties.SensitivePropertyProtectionException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.kms.KmsClient;
import software.amazon.awssdk.services.kms.model.DecryptRequest;
import software.amazon.awssdk.services.kms.model.DecryptResponse;
import software.amazon.awssdk.services.kms.model.DescribeKeyRequest;
import software.amazon.awssdk.services.kms.model.DescribeKeyResponse;
import software.amazon.awssdk.services.kms.model.EncryptRequest;
import software.amazon.awssdk.services.kms.model.EncryptResponse;
import software.amazon.awssdk.services.kms.model.KeyMetadata;

public class AwsKmsSensitivePropertyProvider
extends ClientBasedEncodedSensitivePropertyProvider<KmsClient> {
    protected static final String KEY_ID_PROPERTY = "aws.kms.key.id";
    private static final String IDENTIFIER_KEY = "aws/kms";

    AwsKmsSensitivePropertyProvider(KmsClient kmsClient, Properties properties) throws SensitivePropertyProtectionException {
        super((Object)kmsClient, properties);
    }

    public String getIdentifierKey() {
        return IDENTIFIER_KEY;
    }

    public void cleanUp() {
        KmsClient kmsClient = (KmsClient)this.getClient();
        if (kmsClient == null) {
            this.logger.debug("AWS KMS Client not configured");
        } else {
            kmsClient.close();
        }
    }

    protected void validate(KmsClient kmsClient) {
        if (kmsClient == null) {
            this.logger.debug("AWS KMS Client not configured");
        } else {
            String keyId = this.getKeyId();
            try {
                DescribeKeyRequest describeKeyRequest = (DescribeKeyRequest)DescribeKeyRequest.builder().keyId(keyId).build();
                DescribeKeyResponse describeKeyResponse = kmsClient.describeKey(describeKeyRequest);
                KeyMetadata keyMetadata = describeKeyResponse.keyMetadata();
                if (!keyMetadata.enabled().booleanValue()) {
                    throw new SensitivePropertyProtectionException(String.format("AWS KMS Key [%s] Disabled", keyId));
                }
                this.logger.info("AWS KMS Key [{}] Enabled", (Object)keyId);
            }
            catch (RuntimeException e) {
                throw new SensitivePropertyProtectionException(String.format("AWS KMS Key [%s] Validation Failed", keyId), (Throwable)e);
            }
        }
    }

    protected byte[] getEncrypted(byte[] bytes) {
        SdkBytes plainBytes = SdkBytes.fromByteArray((byte[])bytes);
        EncryptRequest encryptRequest = (EncryptRequest)EncryptRequest.builder().keyId(this.getKeyId()).plaintext(plainBytes).build();
        EncryptResponse response = ((KmsClient)this.getClient()).encrypt(encryptRequest);
        SdkBytes encryptedData = response.ciphertextBlob();
        return encryptedData.asByteArray();
    }

    protected byte[] getDecrypted(byte[] bytes) {
        SdkBytes cipherBytes = SdkBytes.fromByteArray((byte[])bytes);
        DecryptRequest decryptRequest = (DecryptRequest)DecryptRequest.builder().ciphertextBlob(cipherBytes).keyId(this.getKeyId()).build();
        DecryptResponse response = ((KmsClient)this.getClient()).decrypt(decryptRequest);
        SdkBytes decryptedData = response.plaintext();
        return decryptedData.asByteArray();
    }

    private String getKeyId() {
        return this.getProperties().getProperty(KEY_ID_PROPERTY);
    }
}

