/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.encrypt;

import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.KeyDerivationFunction;

public enum PropertyEncryptionMethod {
    NIFI_ARGON2_AES_GCM_128(KeyDerivationFunction.ARGON2, EncryptionMethod.AES_GCM, 128),
    NIFI_ARGON2_AES_GCM_256(KeyDerivationFunction.ARGON2, EncryptionMethod.AES_GCM, 256),
    NIFI_BCRYPT_AES_GCM_128(KeyDerivationFunction.BCRYPT, EncryptionMethod.AES_GCM, 128),
    NIFI_BCRYPT_AES_GCM_256(KeyDerivationFunction.BCRYPT, EncryptionMethod.AES_GCM, 256),
    NIFI_PBKDF2_AES_GCM_128(KeyDerivationFunction.PBKDF2, EncryptionMethod.AES_GCM, 128),
    NIFI_PBKDF2_AES_GCM_256(KeyDerivationFunction.PBKDF2, EncryptionMethod.AES_GCM, 256),
    NIFI_SCRYPT_AES_GCM_128(KeyDerivationFunction.SCRYPT, EncryptionMethod.AES_GCM, 128),
    NIFI_SCRYPT_AES_GCM_256(KeyDerivationFunction.SCRYPT, EncryptionMethod.AES_GCM, 256);

    private static final int HASH_LENGTH_DIVISOR = 8;
    private final KeyDerivationFunction keyDerivationFunction;
    private final EncryptionMethod encryptionMethod;
    private final int keyLength;
    private final int hashLength;

    private PropertyEncryptionMethod(KeyDerivationFunction keyDerivationFunction, EncryptionMethod encryptionMethod, int keyLength) {
        this.keyDerivationFunction = keyDerivationFunction;
        this.encryptionMethod = encryptionMethod;
        this.keyLength = keyLength;
        this.hashLength = keyLength / 8;
    }

    public KeyDerivationFunction getKeyDerivationFunction() {
        return this.keyDerivationFunction;
    }

    public EncryptionMethod getEncryptionMethod() {
        return this.encryptionMethod;
    }

    public int getKeyLength() {
        return this.keyLength;
    }

    public int getHashLength() {
        return this.hashLength;
    }
}

