/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.hpe;

import java.util.Arrays;
import java.util.Optional;
import java.util.ServiceLoader;
import org.apache.nifi.util.hpe.HpeProperties;
import org.apache.nifi.util.hpe.HpePropertiesException;
import org.apache.nifi.util.hpe.HpePropertiesURLClassLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HpePropertiesLoader {
    private static final Logger logger = LoggerFactory.getLogger(HpePropertiesLoader.class);

    public static HpeProperties getHpeProperties() {
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ServiceLoader<HpeProperties> hpePropertiesLoader;
            Optional<HpeProperties> hpePropertiesOptional;
            HpePropertiesURLClassLoader hpePropertiesClassloader = new HpePropertiesURLClassLoader(originalContextClassLoader);
            Thread.currentThread().setContextClassLoader(hpePropertiesClassloader);
            if (logger.isDebugEnabled()) {
                logger.debug("Seeking for HpeProperties implementation by the following paths: {}", (Object)Arrays.toString(hpePropertiesClassloader.getURLs()));
            }
            if ((hpePropertiesOptional = (hpePropertiesLoader = ServiceLoader.load(HpeProperties.class)).findFirst()).isPresent()) {
                HpeProperties hpeProperties = hpePropertiesOptional.get();
                return hpeProperties;
            }
            throw new HpePropertiesException(String.format("No implementations found [%s]", HpeProperties.class.getName()));
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }
}

