/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.reporting.prometheus;

import io.prometheus.client.CollectorRegistry;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.apache.nifi.annotation.configuration.DefaultSchedule;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.metrics.jvm.JmxJvmMetrics;
import org.apache.nifi.metrics.jvm.JvmMetrics;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.prometheus.util.JvmMetricsRegistry;
import org.apache.nifi.prometheus.util.NiFiMetricsRegistry;
import org.apache.nifi.prometheus.util.PrometheusMetricsUtil;
import org.apache.nifi.reporting.AbstractReportingTask;
import org.apache.nifi.reporting.EventAccess;
import org.apache.nifi.reporting.ReportingContext;
import org.apache.nifi.reporting.prometheus.PrometheusServer;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.ssl.RestrictedSSLContextService;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;
import org.eclipse.jetty.server.Server;

@Tags(value={"reporting", "prometheus", "metrics", "time series data"})
@CapabilityDescription(value="Reports metrics in Prometheus format by creating a /metrics HTTP(S) endpoint which can be used for external monitoring of the application. The reporting task reports a set of metrics regarding the JVM (optional) and the NiFi instance. Note that if the underlying Jetty server (i.e. the Prometheus endpoint) cannot be started (for example if two PrometheusReportingTask instances are started on the same port), this may cause a delay in shutting down NiFi while it waits for the server resources to be cleaned up.")
@DefaultSchedule(strategy=SchedulingStrategy.TIMER_DRIVEN, period="60 sec")
public class PrometheusReportingTask
extends AbstractReportingTask {
    private PrometheusServer prometheusServer;
    public static final PropertyDescriptor SSL_CONTEXT = new PropertyDescriptor.Builder().name("prometheus-reporting-task-ssl-context").displayName("SSL Context Service").description("The SSL Context Service to use in order to secure the server. If specified, the server willaccept only HTTPS requests; otherwise, the server will accept only HTTP requests").required(false).identifiesControllerService(RestrictedSSLContextService.class).build();
    public static final PropertyDescriptor METRICS_STRATEGY = new PropertyDescriptor.Builder().name("prometheus-reporting-task-metrics-strategy").displayName("Metrics Reporting Strategy").description("The granularity on which to report metrics. Options include only the root process group, all process groups, or all components").allowableValues(new AllowableValue[]{PrometheusMetricsUtil.METRICS_STRATEGY_ROOT, PrometheusMetricsUtil.METRICS_STRATEGY_PG, PrometheusMetricsUtil.METRICS_STRATEGY_COMPONENTS}).defaultValue(PrometheusMetricsUtil.METRICS_STRATEGY_COMPONENTS.getValue()).required(true).build();
    public static final PropertyDescriptor SEND_JVM_METRICS = new PropertyDescriptor.Builder().name("prometheus-reporting-task-metrics-send-jvm").displayName("Send JVM metrics").description("Send JVM metrics in addition to the NiFi metrics").allowableValues(new String[]{"true", "false"}).defaultValue("false").required(true).build();
    private static final List<PropertyDescriptor> properties;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    @OnScheduled
    public void onScheduled(ConfigurationContext context) {
        SSLContextService sslContextService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        String metricsEndpointPort = context.getProperty(PrometheusMetricsUtil.METRICS_ENDPOINT_PORT).evaluateAttributeExpressions().getValue();
        try {
            ArrayList<Function<ReportingContext, CollectorRegistry>> metricsCollectors = new ArrayList<Function<ReportingContext, CollectorRegistry>>();
            if (sslContextService == null) {
                this.prometheusServer = new PrometheusServer(new InetSocketAddress(Integer.parseInt(metricsEndpointPort)), this.getLogger());
            } else {
                boolean want;
                boolean need;
                String clientAuthValue = context.getProperty(PrometheusMetricsUtil.CLIENT_AUTH).getValue();
                if (PrometheusMetricsUtil.CLIENT_NEED.getValue().equals(clientAuthValue)) {
                    need = true;
                    want = false;
                } else if (PrometheusMetricsUtil.CLIENT_WANT.getValue().equals(clientAuthValue)) {
                    need = false;
                    want = true;
                } else {
                    need = false;
                    want = false;
                }
                this.prometheusServer = new PrometheusServer(Integer.parseInt(metricsEndpointPort), sslContextService, this.getLogger(), need, want);
            }
            Function<ReportingContext, CollectorRegistry> nifiMetrics = reportingContext -> {
                EventAccess eventAccess = reportingContext.getEventAccess();
                ProcessGroupStatus rootGroupStatus = eventAccess.getControllerStatus();
                String instanceId = reportingContext.getProperty(PrometheusMetricsUtil.INSTANCE_ID).evaluateAttributeExpressions().getValue();
                if (instanceId == null) {
                    instanceId = "";
                }
                String metricsStrategy = reportingContext.getProperty(METRICS_STRATEGY).getValue();
                NiFiMetricsRegistry nifiMetricsRegistry = new NiFiMetricsRegistry();
                CollectorRegistry collectorRegistry = PrometheusMetricsUtil.createNifiMetrics((NiFiMetricsRegistry)nifiMetricsRegistry, (ProcessGroupStatus)rootGroupStatus, (String)instanceId, (String)"", (String)"RootProcessGroup", (String)metricsStrategy);
                String rootPGId = StringUtils.isEmpty((String)rootGroupStatus.getId()) ? "" : rootGroupStatus.getId();
                String rootPGName = StringUtils.isEmpty((String)rootGroupStatus.getName()) ? "" : rootGroupStatus.getName();
                nifiMetricsRegistry.setDataPoint((double)eventAccess.getTotalBytesRead(), "TOTAL_BYTES_READ", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
                nifiMetricsRegistry.setDataPoint((double)eventAccess.getTotalBytesWritten(), "TOTAL_BYTES_WRITTEN", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
                nifiMetricsRegistry.setDataPoint((double)eventAccess.getTotalBytesSent(), "TOTAL_BYTES_SENT", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
                nifiMetricsRegistry.setDataPoint((double)eventAccess.getTotalBytesReceived(), "TOTAL_BYTES_RECEIVED", new String[]{instanceId, "RootProcessGroup", rootPGName, rootPGId, ""});
                return collectorRegistry;
            };
            metricsCollectors.add(nifiMetrics);
            if (context.getProperty(SEND_JVM_METRICS).asBoolean().booleanValue()) {
                Function<ReportingContext, CollectorRegistry> jvmMetrics = reportingContext -> {
                    String instanceId = reportingContext.getProperty(PrometheusMetricsUtil.INSTANCE_ID).evaluateAttributeExpressions().getValue();
                    JvmMetricsRegistry jvmMetricsRegistry = new JvmMetricsRegistry();
                    return PrometheusMetricsUtil.createJvmMetrics((JvmMetricsRegistry)jvmMetricsRegistry, (JvmMetrics)JmxJvmMetrics.getInstance(), (String)instanceId);
                };
                metricsCollectors.add(jvmMetrics);
            }
            this.prometheusServer.setMetricsCollectors(metricsCollectors);
            this.getLogger().info("Started Jetty server");
        }
        catch (Exception e) {
            throw new ProcessException("Failed to start Jetty server", (Throwable)e);
        }
    }

    @OnStopped
    public void OnStopped() throws Exception {
        Server server;
        if (this.prometheusServer != null && (server = this.prometheusServer.getServer()) != null) {
            server.stop();
        }
    }

    @OnShutdown
    public void onShutDown() throws Exception {
        Server server;
        if (this.prometheusServer != null && (server = this.prometheusServer.getServer()) != null) {
            server.stop();
        }
    }

    public void onTrigger(ReportingContext context) {
        if (this.prometheusServer != null) {
            this.prometheusServer.setReportingContext(context);
        }
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(PrometheusMetricsUtil.METRICS_ENDPOINT_PORT);
        props.add(PrometheusMetricsUtil.INSTANCE_ID);
        props.add(METRICS_STRATEGY);
        props.add(SEND_JVM_METRICS);
        props.add(SSL_CONTEXT);
        props.add(PrometheusMetricsUtil.CLIENT_AUTH);
        properties = Collections.unmodifiableList(props);
    }
}

