/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.nifi.excel.CellFieldTypeReader;
import org.apache.nifi.excel.ExcelUtils;
import org.apache.nifi.excel.StandardCellFieldTypeReader;
import org.apache.nifi.schema.inference.FieldTypeInference;
import org.apache.nifi.schema.inference.RecordSource;
import org.apache.nifi.schema.inference.SchemaInferenceEngine;
import org.apache.nifi.schema.inference.TimeValueInference;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;

public class ExcelSchemaInference
implements SchemaInferenceEngine<Row> {
    private final CellFieldTypeReader cellFieldTypeReader;

    public ExcelSchemaInference(TimeValueInference timeValueInference) {
        this.cellFieldTypeReader = new StandardCellFieldTypeReader(timeValueInference);
    }

    public RecordSchema inferSchema(RecordSource<Row> recordSource) throws IOException {
        Row row;
        LinkedHashMap<String, FieldTypeInference> typeMap = new LinkedHashMap<String, FieldTypeInference>();
        while ((row = (Row)recordSource.next()) != null) {
            this.inferSchema(row, typeMap);
        }
        return this.createSchema(typeMap);
    }

    private void inferSchema(Row row, Map<String, FieldTypeInference> typeMap) {
        if (ExcelUtils.hasCells(row)) {
            IntStream.range(0, row.getLastCellNum()).forEach(index -> {
                Cell cell = row.getCell(index);
                String fieldName = "column_" + index;
                this.cellFieldTypeReader.inferCellFieldType(cell, fieldName, typeMap);
            });
        }
    }

    private RecordSchema createSchema(Map<String, FieldTypeInference> inferences) {
        List recordFields = inferences.entrySet().stream().map(entry -> new RecordField((String)entry.getKey(), ((FieldTypeInference)entry.getValue()).toDataType(), true)).collect(Collectors.toList());
        return new SimpleRecordSchema(recordFields);
    }
}

