/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.excel;

import java.util.Collections;
import java.util.List;
import org.apache.nifi.serialization.record.RecordSchema;

public class ExcelRecordReaderConfiguration {
    private RecordSchema schema;
    private List<String> requiredSheets;
    private int firstRow;
    private String dateFormat;
    private String timeFormat;
    private String timestampFormat;
    private String password;
    private boolean avoidTempFiles;

    private ExcelRecordReaderConfiguration() {
    }

    public RecordSchema getSchema() {
        return this.schema;
    }

    public List<String> getRequiredSheets() {
        return this.requiredSheets;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public String getTimeFormat() {
        return this.timeFormat;
    }

    public String getTimestampFormat() {
        return this.timestampFormat;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isAvoidTempFiles() {
        return this.avoidTempFiles;
    }

    public static final class Builder {
        private RecordSchema schema;
        private List<String> requiredSheets;
        private int firstRow;
        private String dateFormat;
        private String timeFormat;
        private String timestampFormat;
        private String password;
        private boolean avoidTempFiles;

        public Builder withSchema(RecordSchema schema) {
            this.schema = schema;
            return this;
        }

        public Builder withRequiredSheets(List<String> requiredSheets) {
            this.requiredSheets = requiredSheets;
            return this;
        }

        public Builder withFirstRow(int firstRow) {
            this.firstRow = firstRow;
            return this;
        }

        public Builder withDateFormat(String dateFormat) {
            this.dateFormat = dateFormat;
            return this;
        }

        public Builder withTimeFormat(String timeFormat) {
            this.timeFormat = timeFormat;
            return this;
        }

        public Builder withTimestampFormat(String timestampFormat) {
            this.timestampFormat = timestampFormat;
            return this;
        }

        public Builder withPassword(String password) {
            this.password = password;
            return this;
        }

        public Builder withAvoidTempFiles(boolean avoidTempFiles) {
            this.avoidTempFiles = avoidTempFiles;
            return this;
        }

        public ExcelRecordReaderConfiguration build() {
            ExcelRecordReaderConfiguration excelRecordReaderConfiguration = new ExcelRecordReaderConfiguration();
            excelRecordReaderConfiguration.schema = this.schema;
            excelRecordReaderConfiguration.timeFormat = this.timeFormat;
            excelRecordReaderConfiguration.timestampFormat = this.timestampFormat;
            excelRecordReaderConfiguration.requiredSheets = this.requiredSheets == null ? Collections.emptyList() : this.requiredSheets;
            excelRecordReaderConfiguration.dateFormat = this.dateFormat;
            excelRecordReaderConfiguration.firstRow = this.firstRow;
            excelRecordReaderConfiguration.password = this.password;
            excelRecordReaderConfiguration.avoidTempFiles = this.avoidTempFiles;
            return excelRecordReaderConfiguration;
        }
    }
}

