/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pgp.util;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Date;
import org.bouncycastle.shaded.jce.provider.BouncyCastleProvider;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPKeyPair;
import org.bouncycastle.shaded.openpgp.PGPKeyRingGenerator;
import org.bouncycastle.shaded.openpgp.PGPSecretKey;
import org.bouncycastle.shaded.openpgp.PGPSecretKeyRing;
import org.bouncycastle.shaded.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.shaded.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.shaded.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPContentSignerBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaPGPKeyPair;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcePBESecretKeyEncryptorBuilder;

public class PGPSecretKeyGenerator {
    private static final String RSA_KEY_ALGORITHM = "RSA";
    private static final String DSA_KEY_ALGORITHM = "DSA";
    private static final int DSA_KEY_SIZE = 2048;
    private static final String ELGAMAL_KEY_ALGORITHM = "ELGAMAL";
    private static final String KEY_IDENTITY = PGPSecretKey.class.getSimpleName();
    private static final int KEY_ENCRYPTION_ALGORITHM = 9;

    public static PGPSecretKeyRing generateDsaElGamalSecretKeyRing(char[] keyEncryptionPassword) throws Exception {
        PGPKeyPair dsaKeyPair = PGPSecretKeyGenerator.getDsaKeyPair();
        PGPDigestCalculator digestCalculator = PGPSecretKeyGenerator.getDigestCalculator();
        PBESecretKeyEncryptor encryptor = PGPSecretKeyGenerator.getSecretKeyEncryptor(keyEncryptionPassword, digestCalculator);
        PGPContentSignerBuilder signerBuilder = PGPSecretKeyGenerator.getContentSignerBuilder(dsaKeyPair.getPublicKey().getAlgorithm());
        PGPKeyRingGenerator keyRingGenerator = new PGPKeyRingGenerator(16, dsaKeyPair, KEY_IDENTITY, digestCalculator, null, null, signerBuilder, encryptor);
        PGPKeyPair elGamalKeyPair = PGPSecretKeyGenerator.getElGamalKeyPair();
        keyRingGenerator.addSubKey(elGamalKeyPair);
        return keyRingGenerator.generateSecretKeyRing();
    }

    public static PGPSecretKey generateRsaSecretKey(char[] keyEncryptionPassword) throws Exception {
        PGPKeyPair pgpKeyPair = PGPSecretKeyGenerator.getRsaKeyPair();
        PGPDigestCalculator digestCalculator = PGPSecretKeyGenerator.getDigestCalculator();
        PBESecretKeyEncryptor encryptor = PGPSecretKeyGenerator.getSecretKeyEncryptor(keyEncryptionPassword, digestCalculator);
        PGPContentSignerBuilder signerBuilder = PGPSecretKeyGenerator.getContentSignerBuilder(pgpKeyPair.getPublicKey().getAlgorithm());
        return new PGPSecretKey(16, pgpKeyPair, KEY_IDENTITY, digestCalculator, null, null, signerBuilder, encryptor);
    }

    private static PGPKeyPair getDsaKeyPair() throws NoSuchAlgorithmException, PGPException {
        KeyPairGenerator dsaKeyPairGenerator = KeyPairGenerator.getInstance(DSA_KEY_ALGORITHM);
        dsaKeyPairGenerator.initialize(2048);
        KeyPair dsaKeyPair = dsaKeyPairGenerator.generateKeyPair();
        return PGPSecretKeyGenerator.getPgpKeyPair(dsaKeyPair, 17);
    }

    private static PGPKeyPair getElGamalKeyPair() throws NoSuchAlgorithmException, PGPException {
        KeyPairGenerator elGamalKeyPairGenerator = KeyPairGenerator.getInstance(ELGAMAL_KEY_ALGORITHM, (Provider)new BouncyCastleProvider());
        KeyPair elGamalKeyPair = elGamalKeyPairGenerator.generateKeyPair();
        return PGPSecretKeyGenerator.getPgpKeyPair(elGamalKeyPair, 16);
    }

    private static PGPKeyPair getRsaKeyPair() throws NoSuchAlgorithmException, PGPException {
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance(RSA_KEY_ALGORITHM);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        return PGPSecretKeyGenerator.getPgpKeyPair(keyPair, 1);
    }

    private static PGPKeyPair getPgpKeyPair(KeyPair keyPair, int algorithm) throws PGPException {
        return new JcaPGPKeyPair(algorithm, keyPair, new Date());
    }

    private static PBESecretKeyEncryptor getSecretKeyEncryptor(char[] password, PGPDigestCalculator digestCalculator) {
        return new JcePBESecretKeyEncryptorBuilder(9, digestCalculator).build(password);
    }

    private static PGPContentSignerBuilder getContentSignerBuilder(int algorithm) {
        return new JcaPGPContentSignerBuilder(algorithm, 8);
    }

    private static PGPDigestCalculator getDigestCalculator() throws PGPException {
        return new JcaPGPDigestCalculatorProviderBuilder().build().get(2);
    }
}

