/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.pgp.service.standard;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.pgp.service.api.KeyIdentifierConverter;
import org.apache.nifi.pgp.service.api.PGPPublicKeyService;
import org.apache.nifi.pgp.service.standard.exception.PGPConfigurationException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.util.StringUtils;
import org.bouncycastle.shaded.openpgp.PGPException;
import org.bouncycastle.shaded.openpgp.PGPPublicKey;
import org.bouncycastle.shaded.openpgp.PGPPublicKeyRingCollection;
import org.bouncycastle.shaded.openpgp.PGPUtil;
import org.bouncycastle.shaded.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.shaded.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;

@Tags(value={"PGP", "GPG", "OpenPGP", "Encryption", "Private", "Key", "RFC 4880"})
@CapabilityDescription(value="PGP Public Key Service providing Public Keys loaded from files")
public class StandardPGPPublicKeyService
extends AbstractControllerService
implements PGPPublicKeyService {
    public static final PropertyDescriptor KEYRING_FILE = new PropertyDescriptor.Builder().name("keyring-file").displayName("Keyring File").description("File path to PGP Keyring or Public Key encoded in binary or ASCII Armor").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).build();
    public static final PropertyDescriptor KEYRING = new PropertyDescriptor.Builder().name("keyring").displayName("Keyring").description("PGP Keyring or Public Key encoded in ASCII Armor").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    private static final Charset KEY_CHARSET = StandardCharsets.US_ASCII;
    private static final boolean PARALLEL_DISABLED = false;
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(KEYRING_FILE, KEYRING);
    private volatile List<PGPPublicKey> publicKeys = Collections.emptyList();

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        try {
            ArrayList<PGPPublicKey> extractedPublicKeys = new ArrayList<PGPPublicKey>(this.readKeyringFile((PropertyContext)context));
            extractedPublicKeys.addAll(this.readKeyring((PropertyContext)context));
            this.publicKeys = extractedPublicKeys;
        }
        catch (RuntimeException e) {
            throw new InitializationException("Reading Public Keys Failed", (Throwable)e);
        }
    }

    @OnDisabled
    public void onDisabled() {
        this.publicKeys = Collections.emptyList();
    }

    public Optional<PGPPublicKey> findPublicKey(String search) {
        this.getLogger().debug("Find Public Key [{}]", new Object[]{search});
        return this.publicKeys.stream().filter(publicKey -> this.isPublicKeyMatched((PGPPublicKey)publicKey, search)).findFirst();
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    protected Collection<ValidationResult> customValidate(ValidationContext context) {
        ValidationResult result;
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        ArrayList<PGPPublicKey> extractedPublicKeys = new ArrayList<PGPPublicKey>();
        try {
            extractedPublicKeys.addAll(this.readKeyringFile((PropertyContext)context));
        }
        catch (RuntimeException e) {
            result = new ValidationResult.Builder().valid(false).subject(KEYRING_FILE.getDisplayName()).explanation(String.format("Reading Public Keyring File Failed: %s", e.getMessage())).build();
            results.add(result);
        }
        try {
            extractedPublicKeys.addAll(this.readKeyring((PropertyContext)context));
        }
        catch (RuntimeException e) {
            result = new ValidationResult.Builder().valid(false).subject(KEYRING.getDisplayName()).explanation(String.format("Reading Public Keyring Failed: %s", e.getMessage())).build();
            results.add(result);
        }
        if (extractedPublicKeys.isEmpty()) {
            String explanation = String.format("No Public Keys Read from [%s] or [%s]", KEYRING_FILE.getDisplayName(), KEYRING.getDisplayName());
            result = new ValidationResult.Builder().valid(false).subject(((Object)((Object)this)).getClass().getSimpleName()).explanation(explanation).build();
            results.add(result);
        }
        return results;
    }

    private boolean isPublicKeyMatched(PGPPublicKey publicKey, String search) {
        boolean matched = false;
        String keyId = KeyIdentifierConverter.format((long)publicKey.getKeyID());
        if (keyId.equals(search)) {
            matched = true;
        } else {
            Iterator userIds = publicKey.getUserIDs();
            while (userIds.hasNext()) {
                String userId = (String)userIds.next();
                if (!userId.contains(search)) continue;
                matched = true;
                break;
            }
        }
        return matched;
    }

    private List<PGPPublicKey> readKeyringFile(PropertyContext context) {
        ArrayList<PGPPublicKey> extractedPublicKeys = new ArrayList<PGPPublicKey>();
        String keyringFile = context.getProperty(KEYRING_FILE).evaluateAttributeExpressions().getValue();
        if (StringUtils.isNotBlank((String)keyringFile)) {
            try (FileInputStream inputStream = new FileInputStream(keyringFile);){
                extractedPublicKeys.addAll(this.extractPublicKeys(inputStream));
            }
            catch (IOException | RuntimeException e) {
                String message = String.format("Reading Public Keyring File [%s] Failed", keyringFile);
                throw new PGPConfigurationException(message, e);
            }
        }
        return extractedPublicKeys;
    }

    private List<PGPPublicKey> readKeyring(PropertyContext context) {
        ArrayList<PGPPublicKey> extractedPublicKeys = new ArrayList<PGPPublicKey>();
        String keyring = context.getProperty(KEYRING).getValue();
        if (StringUtils.isNotBlank((String)keyring)) {
            byte[] keyringBytes = keyring.getBytes(KEY_CHARSET);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(keyringBytes);){
                extractedPublicKeys.addAll(this.extractPublicKeys(inputStream));
            }
            catch (IOException | RuntimeException e) {
                throw new PGPConfigurationException("Reading Public Keyring Failed", e);
            }
        }
        return extractedPublicKeys;
    }

    private List<PGPPublicKey> extractPublicKeys(InputStream inputStream) throws IOException {
        List<PGPPublicKey> list;
        block8: {
            JcaKeyFingerprintCalculator calculator = new JcaKeyFingerprintCalculator();
            InputStream decoderStream = PGPUtil.getDecoderStream((InputStream)inputStream);
            try {
                PGPPublicKeyRingCollection keyRings = new PGPPublicKeyRingCollection(decoderStream, (KeyFingerPrintCalculator)calculator);
                list = StreamSupport.stream(keyRings.spliterator(), false).flatMap(keyRing -> StreamSupport.stream(keyRing.spliterator(), false)).collect(Collectors.toList());
                if (decoderStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (decoderStream != null) {
                        try {
                            decoderStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (PGPException e) {
                    throw new PGPConfigurationException("Reading Public Keyring Collection Failed", e);
                }
            }
            decoderStream.close();
        }
        return list;
    }
}

