/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.nifi.provenance.serialization.RecordWriter;
import org.apache.nifi.provenance.toc.TocWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractRecordWriter
implements RecordWriter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRecordWriter.class);
    private final File file;
    private final String storageLocation;
    private final TocWriter tocWriter;
    private final Lock lock = new ReentrantLock();
    private volatile boolean dirty = false;
    private volatile boolean closed = false;

    public AbstractRecordWriter(File file, TocWriter writer) throws IOException {
        logger.trace("Creating Record Writer for {}", (Object)file);
        this.file = file;
        this.storageLocation = file.getName();
        this.tocWriter = writer;
    }

    public AbstractRecordWriter(String storageLocation, TocWriter writer) throws IOException {
        logger.trace("Creating Record Writer for {}", (Object)storageLocation);
        this.file = null;
        this.storageLocation = storageLocation;
        this.tocWriter = writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        logger.trace("Closing Record Writer for {}", (Object)this.getStorageLocation());
        this.lock();
        try {
            this.flush();
            try {
                OutputStream buffered = this.getBufferedOutputStream();
                if (buffered != null && !this.isDirty()) {
                    buffered.close();
                }
            }
            finally {
                OutputStream underlying = this.getUnderlyingOutputStream();
                if (underlying != null) {
                    try {
                        this.getUnderlyingOutputStream().close();
                    }
                    finally {
                        if (this.tocWriter != null) {
                            this.tocWriter.close();
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            this.markDirty();
            throw ioe;
        }
        finally {
            this.unlock();
        }
    }

    protected String getStorageLocation() {
        return this.storageLocation;
    }

    @Override
    public File getFile() {
        return this.file;
    }

    @Override
    public void lock() {
        this.lock.lock();
    }

    @Override
    public void unlock() {
        this.lock.unlock();
    }

    @Override
    public boolean tryLock() {
        boolean obtainedLock = this.lock.tryLock();
        if (obtainedLock && this.isDirty()) {
            this.lock.unlock();
            return false;
        }
        return obtainedLock;
    }

    @Override
    public void markDirty() {
        this.dirty = true;
    }

    @Override
    public boolean isDirty() {
        return this.dirty;
    }

    protected void resetDirtyFlag() {
        this.dirty = false;
    }

    @Override
    public synchronized void sync() throws IOException {
        try {
            if (this.tocWriter != null) {
                this.tocWriter.sync();
            }
            this.syncUnderlyingOutputStream();
        }
        catch (IOException ioe) {
            this.markDirty();
            throw ioe;
        }
    }

    @Override
    public TocWriter getTocWriter() {
        return this.tocWriter;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected abstract OutputStream getBufferedOutputStream();

    protected abstract OutputStream getUnderlyingOutputStream();

    protected abstract void syncUnderlyingOutputStream() throws IOException;
}

