/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.serialization;

import java.util.Optional;

public class StorageSummary {
    private final long eventId;
    private final String storageLocation;
    private final String partitionName;
    private final Integer blockIndex;
    private final long serializedLength;
    private final long bytesWritten;

    public StorageSummary(long eventId, String storageLocation, Integer blockIndex, long serializedLength, long bytesWritten) {
        this(eventId, storageLocation, null, blockIndex, serializedLength, bytesWritten);
    }

    public StorageSummary(long eventId, String storageLocation, String partitionName, Integer blockIndex, long serializedLength, long bytesWritten) {
        this.eventId = eventId;
        this.storageLocation = storageLocation;
        this.partitionName = partitionName;
        this.blockIndex = blockIndex;
        this.serializedLength = serializedLength;
        this.bytesWritten = bytesWritten;
    }

    public long getEventId() {
        return this.eventId;
    }

    public String getStorageLocation() {
        return this.storageLocation;
    }

    public Optional<String> getPartitionName() {
        return Optional.ofNullable(this.partitionName);
    }

    public Integer getBlockIndex() {
        return this.blockIndex;
    }

    public long getSerializedLength() {
        return this.serializedLength;
    }

    public long getBytesWritten() {
        return this.bytesWritten;
    }

    public String toString() {
        return "StorageSummary[eventId=" + this.getEventId() + ", partition=" + (String)this.getPartitionName().orElse(null) + ", location=" + this.getStorageLocation() + "]";
    }
}

