/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.store.iterator;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.store.iterator.EventIterator;

public class AggregateEventIterator
implements EventIterator {
    private final List<EventIterator> iteratorList;
    private final Iterator<EventIterator> iterators;
    private EventIterator currentIterator;

    public AggregateEventIterator(List<EventIterator> eventIterators) {
        this.iteratorList = eventIterators;
        this.iterators = eventIterators.iterator();
        if (this.iterators.hasNext()) {
            this.currentIterator = this.iterators.next();
        }
    }

    @Override
    public Optional<ProvenanceEventRecord> nextEvent() throws IOException {
        while (true) {
            Optional<ProvenanceEventRecord> optionalEvent;
            if ((optionalEvent = this.currentIterator.nextEvent()).isPresent()) {
                return optionalEvent;
            }
            if (!this.iterators.hasNext()) break;
            this.currentIterator = this.iterators.next();
        }
        return Optional.empty();
    }

    @Override
    public void close() throws IOException {
        for (EventIterator iterator : this.iteratorList) {
            iterator.close();
        }
    }
}

