/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.serialization;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.ByteArraySchemaRecordWriter;
import org.apache.nifi.provenance.serialization.RecordWriter;
import org.apache.nifi.provenance.toc.StandardTocWriter;
import org.apache.nifi.provenance.toc.TocUtil;

public class RecordWriters {
    private static final int DEFAULT_COMPRESSION_BLOCK_SIZE = 0x100000;

    public static RecordWriter newSchemaRecordWriter(File file, AtomicLong idGenerator, boolean compressed, boolean createToc) throws IOException {
        return RecordWriters.newSchemaRecordWriter(file, idGenerator, compressed, createToc, 0x100000);
    }

    public static RecordWriter newSchemaRecordWriter(File file, AtomicLong idGenerator, boolean compressed, boolean createToc, int compressionBlockBytes) throws IOException {
        StandardTocWriter tocWriter = createToc ? new StandardTocWriter(TocUtil.getTocFile(file), false, false) : null;
        return new ByteArraySchemaRecordWriter(file, idGenerator, tocWriter, compressed, compressionBlockBytes);
    }
}

