/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.SearchableFields;
import org.apache.nifi.provenance.index.EventIndexSearcher;
import org.apache.nifi.provenance.lucene.DocumentToEventConverter;
import org.apache.nifi.provenance.lucene.IndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LineageQuery {
    public static final int MAX_QUERY_RESULTS = 5000;
    public static final int MAX_LINEAGE_UUIDS = 100;
    private static final Logger logger = LoggerFactory.getLogger(LineageQuery.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<ProvenanceEventRecord> computeLineageForFlowFiles(IndexManager indexManager, File indexDirectory, String lineageIdentifier, Collection<String> flowFileUuids, DocumentToEventConverter docsToEventConverter) throws IOException {
        if (Objects.requireNonNull(flowFileUuids).size() > 100) {
            throw new IllegalArgumentException(String.format("Cannot compute lineage for more than %s FlowFiles. This lineage contains %s.", 100, flowFileUuids.size()));
        }
        if (lineageIdentifier == null && (flowFileUuids == null || flowFileUuids.isEmpty())) {
            throw new IllegalArgumentException("Must specify either Lineage Identifier or FlowFile UUIDs to compute lineage");
        }
        EventIndexSearcher searcher = indexManager.borrowIndexSearcher(indexDirectory);
        try {
            BooleanQuery flowFileIdQuery;
            if (flowFileUuids == null || flowFileUuids.isEmpty()) {
                flowFileIdQuery = null;
            } else {
                BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
                for (String flowFileUuid : flowFileUuids) {
                    TermQuery termQuery = new TermQuery(new Term(SearchableFields.FlowFileUUID.getSearchableFieldName(), flowFileUuid));
                    queryBuilder.add(new BooleanClause((Query)termQuery, BooleanClause.Occur.SHOULD));
                }
                flowFileIdQuery = queryBuilder.build();
            }
            long searchStart = System.nanoTime();
            logger.debug("Searching {} for {}", (Object)indexDirectory, flowFileIdQuery);
            TopDocs uuidQueryTopDocs = searcher.getIndexSearcher().search(flowFileIdQuery, 5000);
            long searchEnd = System.nanoTime();
            Set<ProvenanceEventRecord> recs = docsToEventConverter.convert(uuidQueryTopDocs, searcher.getIndexSearcher().getIndexReader());
            long readDocsEnd = System.nanoTime();
            logger.debug("Finished Lineage Query against {}; Lucene search took {} millis, reading records took {} millis", new Object[]{indexDirectory, TimeUnit.NANOSECONDS.toMillis(searchEnd - searchStart), TimeUnit.NANOSECONDS.toMillis(readDocsEnd - searchEnd)});
            Set<ProvenanceEventRecord> set = recs;
            indexManager.returnIndexSearcher(searcher);
            return set;
        }
        catch (Throwable throwable) {
            try {
                indexManager.returnIndexSearcher(searcher);
                throw throwable;
            }
            catch (FileNotFoundException fnfe) {
                logger.warn("Attempted to search Provenance Index {} but could not find the file due to {}", (Object)indexDirectory, (Object)fnfe);
                if (logger.isDebugEnabled()) {
                    logger.warn("", (Throwable)fnfe);
                }
                return Collections.emptySet();
            }
        }
    }
}

