/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.serialization;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.BlockingQueue;
import org.apache.nifi.provenance.store.EventFileManager;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.provenance.util.CloseableUtil;
import org.apache.nifi.stream.io.ByteCountingOutputStream;
import org.apache.nifi.stream.io.GZIPOutputStream;
import org.apache.nifi.stream.io.NonCloseableOutputStream;
import org.apache.nifi.stream.io.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventFileCompressor
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EventFileCompressor.class);
    private final BlockingQueue<File> filesToCompress;
    private final EventFileManager eventFileManager;
    private volatile boolean shutdown = false;

    public EventFileCompressor(BlockingQueue<File> filesToCompress, EventFileManager eventFileManager) {
        this.filesToCompress = filesToCompress;
        this.eventFileManager = eventFileManager;
    }

    public void shutdown() {
        this.shutdown = true;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void compress(File input, TocReader tocReader, File output, TocWriter tocWriter) throws IOException {
        try (FileInputStream fis = new FileInputStream(input);
             FileOutputStream fos = new FileOutputStream(output);
             ByteCountingOutputStream byteCountingOut = new ByteCountingOutputStream((OutputStream)fos);){
            long blockStart;
            int blockIndex = 0;
            while ((blockStart = tocReader.getBlockOffset(blockIndex)) != -1L) {
                long blockEnd = tocReader.getBlockOffset(blockIndex + 1);
                if (blockEnd < 0L) {
                    blockEnd = input.length();
                }
                long firstEventId = tocReader.getFirstEventIdForBlock(blockIndex);
                long blockStartOffset = byteCountingOut.getBytesWritten();
                try (NonCloseableOutputStream ncos = new NonCloseableOutputStream((OutputStream)byteCountingOut);
                     GZIPOutputStream gzipOut = new GZIPOutputStream((OutputStream)ncos, 1);){
                    StreamUtils.copy((InputStream)fis, (OutputStream)gzipOut, (long)(blockEnd - blockStart));
                }
                tocWriter.addBlockOffset(blockStartOffset, firstEventId);
                ++blockIndex;
            }
        }
        CloseableUtil.closeQuietly(tocReader, tocWriter);
    }
}

