/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance.lucene;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.nifi.provenance.index.EventIndexWriter;

public class LuceneEventIndexWriter
implements EventIndexWriter {
    private final IndexWriter indexWriter;
    private final File directory;
    private final long maxCommitNanos;
    private final AtomicReference<CommitStats> commitStats = new AtomicReference();
    private final AtomicLong totalIndexed = new AtomicLong(0L);
    private final AtomicLong lastCommitTotalIndexed = new AtomicLong(0L);

    public LuceneEventIndexWriter(IndexWriter indexWriter, File directory) {
        this(indexWriter, directory, TimeUnit.SECONDS.toNanos(30L));
    }

    public LuceneEventIndexWriter(IndexWriter indexWriter, File directory, long maxCommitNanos) {
        this.indexWriter = indexWriter;
        this.directory = directory;
        this.maxCommitNanos = maxCommitNanos;
        this.commitStats.set(new CommitStats(0, System.nanoTime() + maxCommitNanos));
    }

    @Override
    public void close() throws IOException {
        this.indexWriter.close();
    }

    @Override
    public boolean index(Document document, int commitThreshold) throws IOException {
        return this.index(Collections.singletonList(document), commitThreshold);
    }

    @Override
    public boolean index(List<Document> documents, int commitThreshold) throws IOException {
        if (documents.isEmpty()) {
            return false;
        }
        int numDocs = documents.size();
        this.indexWriter.addDocuments(documents);
        this.totalIndexed.addAndGet(numDocs);
        boolean updated = false;
        while (!updated) {
            CommitStats stats = this.commitStats.get();
            CommitStats updatedStats = new CommitStats(stats.getIndexedSinceCommit() + numDocs, stats.getNextCommitTimestamp());
            if (updatedStats.getIndexedSinceCommit() >= commitThreshold || System.nanoTime() >= updatedStats.getNextCommitTimestamp()) {
                updatedStats = new CommitStats(0, System.nanoTime() + this.maxCommitNanos);
                updated = this.commitStats.compareAndSet(stats, updatedStats);
                if (!updated) continue;
                return true;
            }
            updated = this.commitStats.compareAndSet(stats, updatedStats);
        }
        return false;
    }

    @Override
    public File getDirectory() {
        return this.directory;
    }

    @Override
    public long commit() throws IOException {
        long lastCommitCount = this.lastCommitTotalIndexed.get();
        long currentCommitCount = this.totalIndexed.get();
        this.indexWriter.commit();
        this.commitStats.set(new CommitStats(0, System.nanoTime() + this.maxCommitNanos));
        this.lastCommitTotalIndexed.set(currentCommitCount);
        return currentCommitCount - lastCommitCount;
    }

    @Override
    public int getEventsIndexedSinceCommit() {
        return this.commitStats.get().getIndexedSinceCommit();
    }

    @Override
    public long getEventsIndexed() {
        return this.totalIndexed.get();
    }

    @Override
    public IndexWriter getIndexWriter() {
        return this.indexWriter;
    }

    public String toString() {
        return "LuceneEventIndexWriter[dir=" + this.directory + "]";
    }

    private static class CommitStats {
        private final long nextCommitTimestamp;
        private final int indexedSinceCommit;

        public CommitStats(int indexedCount, long nextCommitTime) {
            this.nextCommitTimestamp = nextCommitTime;
            this.indexedSinceCommit = indexedCount;
        }

        public long getNextCommitTimestamp() {
            return this.nextCommitTimestamp;
        }

        public int getIndexedSinceCommit() {
            return this.indexedSinceCommit;
        }
    }
}

