/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.provenance.schema.EventRecord;
import org.apache.nifi.provenance.schema.ProvenanceEventSchema;
import org.apache.nifi.provenance.serialization.CompressableRecordWriter;
import org.apache.nifi.provenance.toc.TocWriter;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.SchemaRecordWriter;

public class ByteArraySchemaRecordWriter
extends CompressableRecordWriter {
    private static final RecordSchema eventSchema = ProvenanceEventSchema.PROVENANCE_EVENT_SCHEMA_V1;
    private static final RecordSchema contentClaimSchema = new RecordSchema(eventSchema.getField("Content Claim").getSubFields());
    public static final int SERIALIZATION_VERSION = 1;
    public static final String SERIALIZATION_NAME = "ByteArraySchemaRecordWriter";
    private final SchemaRecordWriter recordWriter = new SchemaRecordWriter();

    public ByteArraySchemaRecordWriter(File file, AtomicLong idGenerator, TocWriter tocWriter, boolean compressed, int uncompressedBlockSize) throws IOException {
        super(file, idGenerator, tocWriter, compressed, uncompressedBlockSize);
    }

    public ByteArraySchemaRecordWriter(OutputStream out, String storageLocation, AtomicLong idGenerator, TocWriter tocWriter, boolean compressed, int uncompressedBlockSize) throws IOException {
        super(out, storageLocation, idGenerator, tocWriter, compressed, uncompressedBlockSize);
    }

    @Override
    protected String getSerializationName() {
        return SERIALIZATION_NAME;
    }

    @Override
    protected int getSerializationVersion() {
        return 1;
    }

    @Override
    public void writeHeader(long firstEventId, DataOutputStream out) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        eventSchema.writeTo((OutputStream)baos);
        out.writeInt(baos.size());
        baos.writeTo(out);
    }

    protected Record createRecord(ProvenanceEventRecord event, long eventId) {
        return new EventRecord(event, eventId, eventSchema, contentClaimSchema);
    }

    @Override
    protected void writeRecord(ProvenanceEventRecord event, long eventId, DataOutputStream out) throws IOException {
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream(256);){
            Record eventRecord = this.createRecord(event, eventId);
            this.recordWriter.writeRecord(eventRecord, (OutputStream)baos);
            out.writeInt(baos.size());
            baos.writeTo(out);
        }
    }
}

