/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.provenance;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.nifi.provenance.StandardProvenanceEventRecord;
import org.apache.nifi.provenance.schema.EventRecord;
import org.apache.nifi.provenance.serialization.CompressableRecordReader;
import org.apache.nifi.provenance.toc.TocReader;
import org.apache.nifi.repository.schema.FieldCache;
import org.apache.nifi.repository.schema.NoOpFieldCache;
import org.apache.nifi.repository.schema.Record;
import org.apache.nifi.repository.schema.RecordSchema;
import org.apache.nifi.repository.schema.SchemaRecordReader;
import org.apache.nifi.stream.io.LimitingInputStream;
import org.apache.nifi.stream.io.StreamUtils;

public class ByteArraySchemaRecordReader
extends CompressableRecordReader {
    private RecordSchema schema;
    private SchemaRecordReader recordReader;

    public ByteArraySchemaRecordReader(InputStream in, String filename, int maxAttributeChars) throws IOException {
        super(in, filename, maxAttributeChars);
    }

    public ByteArraySchemaRecordReader(InputStream in, String filename, TocReader tocReader, int maxAttributeChars) throws IOException {
        super(in, filename, tocReader, maxAttributeChars);
    }

    private void verifySerializationVersion(int serializationVersion) {
        if (serializationVersion > 1) {
            throw new IllegalArgumentException("Unable to deserialize record because the version is " + serializationVersion + " and supported versions are 1-1");
        }
    }

    @Override
    protected void readHeader(DataInputStream in, int serializationVersion) throws IOException {
        this.verifySerializationVersion(serializationVersion);
        int schemaLength = in.readInt();
        byte[] buffer = new byte[schemaLength];
        StreamUtils.fillBuffer((InputStream)in, (byte[])buffer);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(buffer);){
            this.schema = RecordSchema.readFrom((InputStream)bais);
        }
        this.recordReader = SchemaRecordReader.fromSchema((RecordSchema)this.schema, (FieldCache)new NoOpFieldCache());
    }

    @Override
    protected StandardProvenanceEventRecord nextRecord(DataInputStream in, int serializationVersion) throws IOException {
        this.verifySerializationVersion(serializationVersion);
        long byteOffset = this.getBytesConsumed();
        int recordLength = in.readInt();
        LimitingInputStream limitedIn = new LimitingInputStream((InputStream)in, (long)recordLength);
        Record eventRecord = this.recordReader.readRecord((InputStream)limitedIn);
        if (eventRecord == null) {
            return null;
        }
        return EventRecord.getEvent(eventRecord, this.getFilename(), byteOffset, this.getMaxAttributeLength());
    }
}

