/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.filter;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.parquet.filter.RecordFilter;
import org.apache.parquet.filter.UnboundRecordFilter;

public class OffsetRecordFilter
implements RecordFilter {
    private final AtomicLong skipsRemaining;

    public static UnboundRecordFilter offset(long startIndex) {
        AtomicLong skipsRemaining = new AtomicLong(startIndex);
        return readers -> new OffsetRecordFilter(skipsRemaining);
    }

    private OffsetRecordFilter(AtomicLong skipsRemaining) {
        this.skipsRemaining = skipsRemaining;
    }

    public boolean isMatch() {
        return this.skipsRemaining.getAndUpdate(l -> l > 0L ? l - 1L : l) == 0L;
    }
}

