/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.parquet.utils;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.parquet.utils.ParquetConfig;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.parquet.PutParquet;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;

public class ParquetUtils {
    public static final PropertyDescriptor ROW_GROUP_SIZE = new PropertyDescriptor.Builder().name("row-group-size").displayName("Row Group Size").description("The row group size used by the Parquet writer. The value is specified in the format of <Data Size> <Data Unit> where Data Unit is one of B, KB, MB, GB, TB.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor PAGE_SIZE = new PropertyDescriptor.Builder().name("page-size").displayName("Page Size").description("The page size used by the Parquet writer. The value is specified in the format of <Data Size> <Data Unit> where Data Unit is one of B, KB, MB, GB, TB.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor DICTIONARY_PAGE_SIZE = new PropertyDescriptor.Builder().name("dictionary-page-size").displayName("Dictionary Page Size").description("The dictionary page size used by the Parquet writer. The value is specified in the format of <Data Size> <Data Unit> where Data Unit is one of B, KB, MB, GB, TB.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor MAX_PADDING_SIZE = new PropertyDescriptor.Builder().name("max-padding-size").displayName("Max Padding Size").description("The maximum amount of padding that will be used to align row groups with blocks in the underlying filesystem. If the underlying filesystem is not a block filesystem like HDFS, this has no effect. The value is specified in the format of <Data Size> <Data Unit> where Data Unit is one of B, KB, MB, GB, TB.").addValidator(StandardValidators.DATA_SIZE_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor ENABLE_DICTIONARY_ENCODING = new PropertyDescriptor.Builder().name("enable-dictionary-encoding").displayName("Enable Dictionary Encoding").description("Specifies whether dictionary encoding should be enabled for the Parquet writer").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor ENABLE_VALIDATION = new PropertyDescriptor.Builder().name("enable-validation").displayName("Enable Validation").description("Specifies whether validation should be enabled for the Parquet writer").allowableValues(new String[]{"true", "false"}).build();
    public static final PropertyDescriptor WRITER_VERSION = new PropertyDescriptor.Builder().name("writer-version").displayName("Writer Version").description("Specifies the version used by Parquet writer").allowableValues((Enum[])ParquetProperties.WriterVersion.values()).build();
    public static final PropertyDescriptor AVRO_READ_COMPATIBILITY = new PropertyDescriptor.Builder().name("avro-read-compatibility").displayName("Avro Read Compatibility").description("Specifies the value for 'parquet.avro.compatible' in the underlying Parquet library").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor AVRO_ADD_LIST_ELEMENT_RECORDS = new PropertyDescriptor.Builder().name("avro-add-list-element-records").displayName("Avro Add List Element Records").description("Specifies the value for 'parquet.avro.add-list-element-records' in the underlying Parquet library").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final PropertyDescriptor AVRO_WRITE_OLD_LIST_STRUCTURE = new PropertyDescriptor.Builder().name("avro-write-old-list-structure").displayName("Avro Write Old List Structure").description("Specifies the value for 'parquet.avro.write-old-list-structure' in the underlying Parquet library").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    public static final List<AllowableValue> COMPRESSION_TYPES = ParquetUtils.getCompressionTypes();
    public static final String COMPRESSION_TYPE_PROP_NAME = "compression-type";
    public static final PropertyDescriptor COMPRESSION_TYPE = new PropertyDescriptor.Builder().name("compression-type").displayName("Compression Type").description("The type of compression for the file being written.").allowableValues(COMPRESSION_TYPES.toArray(new AllowableValue[0])).defaultValue(COMPRESSION_TYPES.get(0).getValue()).required(true).build();

    private static List<AllowableValue> getCompressionTypes() {
        ArrayList<AllowableValue> compressionTypes = new ArrayList<AllowableValue>();
        for (CompressionCodecName compressionCodecName : CompressionCodecName.values()) {
            String name = compressionCodecName.name();
            compressionTypes.add(new AllowableValue(name, name));
        }
        return Collections.unmodifiableList(compressionTypes);
    }

    public static ParquetConfig createParquetConfig(PropertyContext context, Map<String, String> variables) {
        ParquetConfig parquetConfig = new ParquetConfig();
        boolean overwrite = true;
        if (context.getProperty(PutParquet.OVERWRITE).isSet()) {
            overwrite = context.getProperty(PutParquet.OVERWRITE).asBoolean();
        }
        ParquetFileWriter.Mode mode = overwrite ? ParquetFileWriter.Mode.OVERWRITE : ParquetFileWriter.Mode.CREATE;
        parquetConfig.setWriterMode(mode);
        if (context.getProperty(COMPRESSION_TYPE).isSet()) {
            String compressionTypeValue = context.getProperty(COMPRESSION_TYPE).getValue();
            CompressionCodecName codecName = CompressionCodecName.valueOf((String)compressionTypeValue);
            parquetConfig.setCompressionCodec(codecName);
        }
        if (context.getProperty(ROW_GROUP_SIZE).isSet()) {
            try {
                Double rowGroupSize = context.getProperty(ROW_GROUP_SIZE).evaluateAttributeExpressions(variables).asDataSize(DataUnit.B);
                if (rowGroupSize != null) {
                    parquetConfig.setRowGroupSize(rowGroupSize.intValue());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid data size for " + ROW_GROUP_SIZE.getDisplayName(), e);
            }
        }
        if (context.getProperty(PAGE_SIZE).isSet()) {
            try {
                Double pageSize = context.getProperty(PAGE_SIZE).evaluateAttributeExpressions(variables).asDataSize(DataUnit.B);
                if (pageSize != null) {
                    parquetConfig.setPageSize(pageSize.intValue());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid data size for " + PAGE_SIZE.getDisplayName(), e);
            }
        }
        if (context.getProperty(DICTIONARY_PAGE_SIZE).isSet()) {
            try {
                Double dictionaryPageSize = context.getProperty(DICTIONARY_PAGE_SIZE).evaluateAttributeExpressions(variables).asDataSize(DataUnit.B);
                if (dictionaryPageSize != null) {
                    parquetConfig.setDictionaryPageSize(dictionaryPageSize.intValue());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid data size for " + DICTIONARY_PAGE_SIZE.getDisplayName(), e);
            }
        }
        if (context.getProperty(MAX_PADDING_SIZE).isSet()) {
            try {
                Double maxPaddingSize = context.getProperty(MAX_PADDING_SIZE).evaluateAttributeExpressions(variables).asDataSize(DataUnit.B);
                if (maxPaddingSize != null) {
                    parquetConfig.setMaxPaddingSize(maxPaddingSize.intValue());
                }
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Invalid data size for " + MAX_PADDING_SIZE.getDisplayName(), e);
            }
        }
        if (context.getProperty(ENABLE_DICTIONARY_ENCODING).isSet()) {
            boolean enableDictionaryEncoding = context.getProperty(ENABLE_DICTIONARY_ENCODING).asBoolean();
            parquetConfig.setEnableDictionaryEncoding(enableDictionaryEncoding);
        }
        if (context.getProperty(ENABLE_VALIDATION).isSet()) {
            boolean enableValidation = context.getProperty(ENABLE_VALIDATION).asBoolean();
            parquetConfig.setEnableValidation(enableValidation);
        }
        if (context.getProperty(WRITER_VERSION).isSet()) {
            String writerVersionValue = context.getProperty(WRITER_VERSION).getValue();
            parquetConfig.setWriterVersion(ParquetProperties.WriterVersion.valueOf((String)writerVersionValue));
        }
        if (context.getProperty(AVRO_READ_COMPATIBILITY).isSet()) {
            boolean avroReadCompatibility = context.getProperty(AVRO_READ_COMPATIBILITY).asBoolean();
            parquetConfig.setAvroReadCompatibility(avroReadCompatibility);
        }
        if (context.getProperty(AVRO_ADD_LIST_ELEMENT_RECORDS).isSet()) {
            boolean avroAddListElementRecords = context.getProperty(AVRO_ADD_LIST_ELEMENT_RECORDS).asBoolean();
            parquetConfig.setAvroAddListElementRecords(avroAddListElementRecords);
        }
        if (context.getProperty(AVRO_WRITE_OLD_LIST_STRUCTURE).isSet()) {
            boolean avroWriteOldListStructure = context.getProperty(AVRO_WRITE_OLD_LIST_STRUCTURE).asBoolean();
            parquetConfig.setAvroWriteOldListStructure(avroWriteOldListStructure);
        }
        return parquetConfig;
    }

    public static void applyCommonConfig(ParquetWriter.Builder<?, ?> builder, Configuration conf, ParquetConfig parquetConfig) {
        builder.withConf(conf);
        builder.withCompressionCodec(parquetConfig.getCompressionCodec());
        if (parquetConfig.getRowGroupSize() != null) {
            builder.withRowGroupSize(parquetConfig.getRowGroupSize().intValue());
        }
        if (parquetConfig.getPageSize() != null) {
            builder.withPageSize(parquetConfig.getPageSize().intValue());
        }
        if (parquetConfig.getDictionaryPageSize() != null) {
            builder.withDictionaryPageSize(parquetConfig.getDictionaryPageSize().intValue());
        }
        if (parquetConfig.getMaxPaddingSize() != null) {
            builder.withMaxPaddingSize(parquetConfig.getMaxPaddingSize().intValue());
        }
        if (parquetConfig.getEnableDictionaryEncoding() != null) {
            builder.withDictionaryEncoding(parquetConfig.getEnableDictionaryEncoding().booleanValue());
        }
        if (parquetConfig.getEnableValidation() != null) {
            builder.withValidation(parquetConfig.getEnableValidation().booleanValue());
        }
        if (parquetConfig.getWriterVersion() != null) {
            builder.withWriterVersion(parquetConfig.getWriterVersion());
        }
        if (parquetConfig.getWriterMode() != null) {
            builder.withWriteMode(parquetConfig.getWriterMode());
        }
        ParquetUtils.applyCommonConfig(conf, parquetConfig);
    }

    public static void applyCommonConfig(Configuration conf, ParquetConfig parquetConfig) {
        if (parquetConfig.getAvroReadCompatibility() != null) {
            conf.setBoolean("parquet.avro.compatible", parquetConfig.getAvroReadCompatibility().booleanValue());
        }
        if (parquetConfig.getAvroAddListElementRecords() != null) {
            conf.setBoolean("parquet.avro.add-list-element-records", parquetConfig.getAvroAddListElementRecords().booleanValue());
        }
        if (parquetConfig.getAvroWriteOldListStructure() != null) {
            conf.setBoolean("parquet.avro.write-old-list-structure", parquetConfig.getAvroWriteOldListStructure().booleanValue());
        }
        conf.setBoolean("parquet.avro.readInt96AsFixed", true);
        if (parquetConfig.getInt96Fields() != null) {
            conf.setStrings("parquet.avro.writeFixedAsInt96", new String[]{parquetConfig.getInt96Fields()});
        }
    }
}

