/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.oauth2;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.FormBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.oauth2.AccessToken;
import org.apache.nifi.oauth2.AccessTokenAcquisitionException;
import org.apache.nifi.oauth2.OAuth2TokenProvider;
import org.apache.nifi.oauth2.StandardOauth2AccessTokenProvider;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.ssl.SSLContextService;
import org.apache.nifi.util.StringUtils;

@Deprecated
@DeprecationNotice(alternatives={StandardOauth2AccessTokenProvider.class})
@Tags(value={"oauth2", "provider", "authorization"})
@CapabilityDescription(value="This controller service provides a way of working with access and refresh tokens via the password and client_credential grant flows in the OAuth2 specification. It is meant to provide a way for components to get a token from an oauth2 provider and pass that token as a part of a header to another service.")
public class OAuth2TokenProviderImpl
extends AbstractControllerService
implements OAuth2TokenProvider {
    private String resourceServerUrl;
    private SSLContext sslContext;
    private SSLContextService sslService;
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public static final String KEY_ACCESS_TOKEN = "access_token";
    public static final String KEY_REFRESH_TOKEN = "refresh_token";
    public static final String KEY_EXPIRES = "expires_in";
    public static final String KEY_TOKEN_TYPE = "token_type";
    public static final String KEY_SCOPE = "scope";

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTIES;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.resourceServerUrl = context.getProperty(ACCESS_TOKEN_URL).evaluateAttributeExpressions().getValue();
        this.sslService = (SSLContextService)context.getProperty(SSL_CONTEXT).asControllerService(SSLContextService.class);
        this.sslContext = this.sslService == null ? null : this.sslService.createContext();
    }

    public AccessToken getAccessTokenByPassword(String clientId, String clientSecret, String username, String password) throws AccessTokenAcquisitionException {
        OkHttpClient.Builder builder = this.getClientBuilder();
        OkHttpClient client = builder.build();
        FormBody body = new FormBody.Builder().add("username", username).add("password", password).add("client_id", clientId).add("client_secret", clientSecret).add("grant_type", "password").build();
        Request newRequest = new Request.Builder().url(this.resourceServerUrl).post((RequestBody)body).build();
        return this.executePost(client, newRequest);
    }

    private OkHttpClient.Builder getClientBuilder() {
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
        if (this.sslService != null) {
            X509TrustManager trustManager = this.sslService.createTrustManager();
            clientBuilder.sslSocketFactory(this.sslContext.getSocketFactory(), trustManager);
        }
        return clientBuilder;
    }

    private AccessToken executePost(OkHttpClient httpClient, Request newRequest) throws AccessTokenAcquisitionException {
        try {
            Response response = httpClient.newCall(newRequest).execute();
            String body = response.body().string();
            if (response.code() >= 300) {
                this.getLogger().error(String.format("Bad response from the server during oauth2 request:\n%s", body));
                throw new AccessTokenAcquisitionException(String.format("Got HTTP %d during oauth2 request.", response.code()));
            }
            return this.parseTokenResponse(body);
        }
        catch (IOException e) {
            throw new AccessTokenAcquisitionException((Throwable)e);
        }
    }

    public AccessToken getAccessTokenByClientCredentials(String clientId, String clientSecret) throws AccessTokenAcquisitionException {
        OkHttpClient.Builder builder = this.getClientBuilder();
        OkHttpClient client = builder.build();
        FormBody body = new FormBody.Builder().add("grant_type", "client_credentials").add("client_id", clientId).add("client_secret", clientSecret).build();
        Request newRequest = new Request.Builder().url(this.resourceServerUrl).post((RequestBody)body).build();
        return this.executePost(client, newRequest);
    }

    public AccessToken refreshToken(AccessToken refreshThis) throws AccessTokenAcquisitionException {
        if (StringUtils.isEmpty((String)refreshThis.getRefreshToken())) {
            throw new ProcessException("Missing refresh token. Refresh cannot happen.");
        }
        OkHttpClient.Builder builder = this.getClientBuilder();
        OkHttpClient client = builder.build();
        FormBody body = new FormBody.Builder().add("grant_type", KEY_REFRESH_TOKEN).add(KEY_REFRESH_TOKEN, refreshThis.getRefreshToken()).build();
        Request newRequest = new Request.Builder().url(this.resourceServerUrl).post((RequestBody)body).build();
        return this.executePost(client, newRequest);
    }

    public AccessToken parseTokenResponse(String rawResponse) {
        try {
            Map parsed = (Map)MAPPER.readValue(rawResponse, Map.class);
            String accessToken = (String)parsed.get(KEY_ACCESS_TOKEN);
            String refreshToken = (String)parsed.get(KEY_REFRESH_TOKEN);
            Integer expires = (Integer)parsed.get(KEY_EXPIRES);
            String tokenType = (String)parsed.get(KEY_TOKEN_TYPE);
            String scope = (String)parsed.get(KEY_SCOPE);
            if (StringUtils.isEmpty((String)accessToken)) {
                throw new Exception(String.format("Missing value for %s", KEY_ACCESS_TOKEN));
            }
            if (StringUtils.isEmpty((String)tokenType)) {
                throw new Exception(String.format("Missing value for %s", KEY_TOKEN_TYPE));
            }
            return new AccessToken(accessToken, refreshToken, tokenType, (long)expires.intValue(), scope);
        }
        catch (Exception ex) {
            throw new ProcessException((Throwable)ex);
        }
    }
}

