/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.oauth2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import okhttp3.Protocol;
import org.apache.nifi.components.DescribedValue;

public enum HttpProtocolStrategy implements DescribedValue
{
    HTTP_1_1("http/1.1", "HTTP/1.1", Collections.singletonList(Protocol.HTTP_1_1)),
    H2_HTTP_1_1("h2 http/1.1", "HTTP/2 and HTTP/1.1 negotiated based on requested protocols", Arrays.asList(Protocol.HTTP_1_1, Protocol.HTTP_2)),
    H2("h2", "HTTP/2", Collections.singletonList(Protocol.HTTP_2));

    private final String displayName;
    private final String description;
    private final List<Protocol> protocols;

    private HttpProtocolStrategy(String displayName, String description, List<Protocol> protocols) {
        this.displayName = displayName;
        this.description = description;
        this.protocols = protocols;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Protocol> getProtocols() {
        return this.protocols;
    }
}

