/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.mongodb;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoDatabase;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.mongodb.MongoDBClientService;
import org.apache.nifi.ssl.SSLContextService;
import org.bson.Document;
import org.bson.conversions.Bson;

@Tags(value={"mongo", "mongodb", "service"})
@CapabilityDescription(value="Provides a controller service that configures a connection to MongoDB and provides access to that connection to other Mongo-related components.")
public class MongoDBControllerService
extends AbstractControllerService
implements MongoDBClientService {
    private String uri;
    static List<PropertyDescriptor> descriptors = new ArrayList<PropertyDescriptor>();
    protected MongoClient mongoClient;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.uri = this.getURI(context);
        this.mongoClient = this.createClient(context, this.mongoClient);
    }

    protected MongoClient createClient(ConfigurationContext context, MongoClient existing) {
        if (existing != null) {
            this.closeClient(existing);
        }
        this.getLogger().info("Creating MongoClient");
        SSLContextService sslService = (SSLContextService)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
        SSLContext sslContext = sslService == null ? null : sslService.createContext();
        try {
            if (sslContext == null) {
                return new MongoClient(new MongoClientURI(this.getURI(context)));
            }
            return new MongoClient(new MongoClientURI(this.getURI(context), this.getClientOptions(sslContext)));
        }
        catch (Exception e) {
            this.getLogger().error("Failed to schedule {} due to {}", new Object[]{((Object)((Object)this)).getClass().getName(), e}, (Throwable)e);
            throw e;
        }
    }

    protected MongoClientOptions.Builder getClientOptions(SSLContext sslContext) {
        MongoClientOptions.Builder builder = MongoClientOptions.builder();
        builder.sslEnabled(true);
        builder.sslContext(sslContext);
        return builder;
    }

    @OnStopped
    public final void onStopped() {
        this.closeClient(this.mongoClient);
    }

    private void closeClient(MongoClient client) {
        if (client != null) {
            client.close();
        }
    }

    protected String getURI(ConfigurationContext context) {
        String uri = context.getProperty(URI).evaluateAttributeExpressions().getValue();
        String user = context.getProperty(DB_USER).evaluateAttributeExpressions().getValue();
        String passw = context.getProperty(DB_PASSWORD).evaluateAttributeExpressions().getValue();
        if (!uri.contains("@") && user != null && passw != null) {
            try {
                return uri.replaceFirst("://", "://" + URLEncoder.encode(user, StandardCharsets.UTF_8.toString()) + ":" + URLEncoder.encode(passw, StandardCharsets.UTF_8.toString()) + "@");
            }
            catch (UnsupportedEncodingException e) {
                this.getLogger().warn("Failed to URL encode username and/or password. Using original URI.");
                return uri;
            }
        }
        return uri;
    }

    public WriteConcern getWriteConcern(ConfigurationContext context) {
        String writeConcernProperty = context.getProperty(WRITE_CONCERN).getValue();
        WriteConcern writeConcern = null;
        switch (writeConcernProperty) {
            case "ACKNOWLEDGED": {
                writeConcern = WriteConcern.ACKNOWLEDGED;
                break;
            }
            case "UNACKNOWLEDGED": {
                writeConcern = WriteConcern.UNACKNOWLEDGED;
                break;
            }
            case "FSYNCED": {
                writeConcern = WriteConcern.JOURNALED;
                this.getLogger().warn("Using deprecated write concern FSYNCED");
                break;
            }
            case "JOURNALED": {
                writeConcern = WriteConcern.JOURNALED;
                break;
            }
            case "REPLICA_ACKNOWLEDGED": {
                writeConcern = WriteConcern.W2;
                this.getLogger().warn("Using deprecated write concern REPLICA_ACKNOWLEDGED");
                break;
            }
            case "MAJORITY": {
                writeConcern = WriteConcern.MAJORITY;
                break;
            }
            case "W1": {
                writeConcern = WriteConcern.W1;
                break;
            }
            case "W2": {
                writeConcern = WriteConcern.W2;
                break;
            }
            case "W3": {
                writeConcern = WriteConcern.W3;
                break;
            }
            default: {
                writeConcern = WriteConcern.ACKNOWLEDGED;
            }
        }
        return writeConcern;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return descriptors;
    }

    @OnDisabled
    public void onDisable() {
        this.mongoClient.close();
    }

    public MongoDatabase getDatabase(String name) {
        return this.mongoClient.getDatabase(name);
    }

    public String getURI() {
        return this.uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigVerificationResult> verify(ConfigurationContext context, ComponentLog verificationLogger, Map<String, String> variables) {
        ConfigVerificationResult.Builder connectionSuccessful = new ConfigVerificationResult.Builder().verificationStepName("Connection test");
        MongoClient client = null;
        try {
            client = this.createClient(context, null);
            MongoDatabase db = client.getDatabase("test");
            db.runCommand((Bson)new Document("buildInfo", (Object)1));
            connectionSuccessful.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL);
        }
        catch (Exception ex) {
            connectionSuccessful.explanation(ex.getMessage()).outcome(ConfigVerificationResult.Outcome.FAILED);
        }
        finally {
            this.closeClient(client);
        }
        return Arrays.asList(connectionSuccessful.build());
    }

    static {
        descriptors.add(URI);
        descriptors.add(DB_USER);
        descriptors.add(DB_PASSWORD);
        descriptors.add(SSL_CONTEXT_SERVICE);
        descriptors.add(CLIENT_AUTH);
    }
}

