/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import com.mongodb.client.MongoCollection;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.AbstractMongoProcessor;
import org.bson.Document;

public abstract class AbstractMongoQueryProcessor
extends AbstractMongoProcessor {
    public static final String DB_NAME = "mongo.database.name";
    public static final String COL_NAME = "mongo.collection.name";
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that have the results of a successful query execution go here.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All input FlowFiles that are part of a failed query execution go here.").build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("All input FlowFiles that are part of a successful query execution go here.").build();
    public static final PropertyDescriptor QUERY = new PropertyDescriptor.Builder().name("Query").description("The selection criteria to do the lookup. If the field is left blank, it will look for input from an incoming connection from another processor to provide the query as a valid JSON document inside of the FlowFile's body. If this field is left blank and a timer is enabled instead of an incoming connection, that will result in a full collection fetch using a \"{}\" query.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor PROJECTION = new PropertyDescriptor.Builder().name("Projection").description("The fields to be returned from the documents in the result set; must be a valid BSON document").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor SORT = new PropertyDescriptor.Builder().name("Sort").description("The fields by which to sort; must be a valid BSON document").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator((Validator)JsonValidator.INSTANCE).build();
    public static final PropertyDescriptor LIMIT = new PropertyDescriptor.Builder().name("Limit").description("The maximum number of elements to return").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    public static final PropertyDescriptor BATCH_SIZE = new PropertyDescriptor.Builder().name("Batch Size").description("The number of elements to be returned from the server in one batch").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();
    static final PropertyDescriptor RESULTS_PER_FLOWFILE = new PropertyDescriptor.Builder().name("results-per-flowfile").displayName("Results Per FlowFile").description("How many results to put into a FlowFile at once. The whole body will be treated as a JSON array of results.").required(false).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.POSITIVE_INTEGER_VALIDATOR).build();

    protected Document getQuery(ProcessContext context, ProcessSession session, FlowFile input) {
        Document query = null;
        if (context.getProperty(QUERY).isSet()) {
            query = Document.parse((String)context.getProperty(QUERY).evaluateAttributeExpressions(input).getValue());
        } else if (!context.getProperty(QUERY).isSet() && input == null) {
            query = Document.parse((String)"{}");
        } else {
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                session.exportTo(input, (OutputStream)out);
                out.close();
                query = Document.parse((String)new String(out.toByteArray()));
            }
            catch (Exception ex) {
                this.getLogger().error("Error reading FlowFile : ", (Throwable)ex);
                throw new ProcessException((Throwable)ex);
            }
        }
        return query;
    }

    protected Map<String, String> getAttributes(ProcessContext context, FlowFile input, Document query, MongoCollection collection) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put(CoreAttributes.MIME_TYPE.key(), "application/json");
        if (context.getProperty(QUERY_ATTRIBUTE).isSet()) {
            String queryAttr = context.getProperty(QUERY_ATTRIBUTE).evaluateAttributeExpressions(input).getValue();
            attributes.put(queryAttr, query.toJson());
        }
        attributes.put(DB_NAME, collection.getNamespace().getDatabaseName());
        attributes.put(COL_NAME, collection.getNamespace().getCollectionName());
        return attributes;
    }
}

