/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.WriteConcern;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.model.ReplaceOptions;
import com.mongodb.client.model.UpdateOptions;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.EventDriven;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SystemResource;
import org.apache.nifi.annotation.behavior.SystemResourceConsideration;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.JsonValidator;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.mongodb.AbstractMongoProcessor;
import org.apache.nifi.stream.io.StreamUtils;
import org.apache.nifi.util.StringUtils;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;

@EventDriven
@Tags(value={"mongodb", "insert", "update", "write", "put"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Writes the contents of a FlowFile to MongoDB")
@SystemResourceConsideration(resource=SystemResource.MEMORY)
public class PutMongo
extends AbstractMongoProcessor {
    static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that are written to MongoDB are routed to this relationship").build();
    static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that cannot be written to MongoDB are routed to this relationship").build();
    static final String MODE_INSERT = "insert";
    static final String MODE_UPDATE = "update";
    static final AllowableValue UPDATE_WITH_DOC = new AllowableValue("doc", "With whole document");
    static final AllowableValue UPDATE_WITH_OPERATORS = new AllowableValue("operators", "With operators enabled");
    static final PropertyDescriptor MODE = new PropertyDescriptor.Builder().name("Mode").description("Indicates whether the processor should insert or update content").required(true).allowableValues(new String[]{"insert", "update"}).defaultValue("insert").build();
    static final PropertyDescriptor UPSERT = new PropertyDescriptor.Builder().name("Upsert").description("When true, inserts a document if no document matches the update query criteria; this property is valid only when using update mode, otherwise it is ignored").required(true).allowableValues(new String[]{"true", "false"}).addValidator(StandardValidators.BOOLEAN_VALIDATOR).defaultValue("false").build();
    static final PropertyDescriptor UPDATE_QUERY_KEY = new PropertyDescriptor.Builder().name("Update Query Key").description("Key name used to build the update query criteria; this property is valid only when using update mode, otherwise it is ignored. Example: _id").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor UPDATE_QUERY = new PropertyDescriptor.Builder().name("putmongo-update-query").displayName("Update Query").description("Specify a full MongoDB query to be used for the lookup query to do an update/upsert.").required(false).addValidator((Validator)JsonValidator.INSTANCE).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    static final PropertyDescriptor UPDATE_MODE = new PropertyDescriptor.Builder().displayName("Update Mode").name("put-mongo-update-mode").required(true).allowableValues(new AllowableValue[]{UPDATE_WITH_DOC, UPDATE_WITH_OPERATORS}).defaultValue(UPDATE_WITH_DOC.getValue()).description("Choose an update mode. You can either supply a JSON document to use as a direct replacement or specify a document that contains update operators like $set, $unset, and $inc. When Operators mode is enabled, the flowfile content is expected to be the operator part for example: {$set:{\"key\": \"value\"},$inc:{\"count\":1234}} and the update query will come from the configured Update Query property.").build();
    static final PropertyDescriptor CHARACTER_SET = new PropertyDescriptor.Builder().name("Character Set").description("The Character Set in which the data is encoded").required(true).addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).defaultValue("UTF-8").build();
    private static final Set<Relationship> relationships;
    private static final List<PropertyDescriptor> propertyDescriptors;

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    @Override
    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> problems = new ArrayList<ValidationResult>();
        if (validationContext.getProperty(MODE).getValue().equals(MODE_INSERT)) {
            return problems;
        }
        boolean queryKey = validationContext.getProperty(UPDATE_QUERY_KEY).isSet();
        boolean query = validationContext.getProperty(UPDATE_QUERY).isSet();
        if (queryKey && query) {
            problems.add(new ValidationResult.Builder().valid(false).explanation("Both update query key and update query cannot be set at the same time.").build());
        } else if (!queryKey && !query) {
            problems.add(new ValidationResult.Builder().valid(false).explanation("Either the update query key or the update query field must be set.").build());
        }
        return problems;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        ComponentLog logger = this.getLogger();
        Charset charset = Charset.forName(context.getProperty(CHARACTER_SET).getValue());
        String mode = context.getProperty(MODE).getValue();
        String updateMode = context.getProperty(UPDATE_MODE).getValue();
        WriteConcern writeConcern = this.getWriteConcern(context);
        try {
            Document doc;
            MongoCollection collection = this.getCollection(context, flowFile).withWriteConcern(writeConcern);
            byte[] content = new byte[(int)flowFile.getSize()];
            session.read(flowFile, in -> StreamUtils.fillBuffer((InputStream)in, (byte[])content, (boolean)true));
            Object object = doc = mode.equals(MODE_INSERT) || mode.equals(MODE_UPDATE) && updateMode.equals(UPDATE_WITH_DOC.getValue()) ? Document.parse((String)new String(content, charset)) : BasicDBObject.parse((String)new String(content, charset));
            if (MODE_INSERT.equalsIgnoreCase(mode)) {
                collection.insertOne((Object)doc);
                logger.info("inserted {} into MongoDB", new Object[]{flowFile});
            } else {
                Document query;
                boolean upsert = context.getProperty(UPSERT).asBoolean();
                String updateKey = context.getProperty(UPDATE_QUERY_KEY).evaluateAttributeExpressions(flowFile).getValue();
                String filterQuery = context.getProperty(UPDATE_QUERY).evaluateAttributeExpressions(flowFile).getValue();
                if (!StringUtils.isBlank((String)updateKey)) {
                    query = this.parseUpdateKey(updateKey, (Map)doc);
                    this.removeUpdateKeys(updateKey, (Map)doc);
                } else {
                    query = Document.parse((String)filterQuery);
                }
                if (updateMode.equals(UPDATE_WITH_DOC.getValue())) {
                    collection.replaceOne((Bson)query, (Object)doc, new ReplaceOptions().upsert(upsert));
                } else {
                    BasicDBObject update = (BasicDBObject)doc;
                    update.remove((Object)updateKey);
                    collection.updateOne((Bson)query, (Bson)update, new UpdateOptions().upsert(upsert));
                }
                logger.info("updated {} into MongoDB", new Object[]{flowFile});
            }
            session.getProvenanceReporter().send(flowFile, this.getURI(context));
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            logger.error("Failed to insert {} into MongoDB due to {}", new Object[]{flowFile, e}, (Throwable)e);
            session.transfer(flowFile, REL_FAILURE);
            context.yield();
        }
    }

    private void removeUpdateKeys(String updateKeyParam, Map doc) {
        String[] parts;
        for (String part : parts = updateKeyParam.split(",[\\s]*")) {
            if (!part.contains(".")) continue;
            doc.remove(part);
        }
    }

    private Document parseUpdateKey(String updateKey, Map doc) {
        Document retVal;
        if (updateKey.equals("_id")) {
            retVal = doc.get("_id") instanceof ObjectId ? new Document("_id", doc.get("_id")) : (ObjectId.isValid((String)((String)doc.get("_id"))) ? new Document("_id", (Object)new ObjectId((String)doc.get("_id"))) : new Document("_id", doc.get("_id")));
        } else if (updateKey.contains(",")) {
            String[] parts = updateKey.split(",[\\s]*");
            retVal = new Document();
            for (String part : parts) {
                retVal.append(part, doc.get(part));
            }
        } else {
            retVal = new Document(updateKey, doc.get(updateKey));
        }
        return retVal;
    }

    @Override
    protected WriteConcern getWriteConcern(ProcessContext context) {
        String writeConcernProperty = context.getProperty(WRITE_CONCERN).getValue();
        WriteConcern writeConcern = null;
        switch (writeConcernProperty) {
            case "ACKNOWLEDGED": {
                writeConcern = WriteConcern.ACKNOWLEDGED;
                break;
            }
            case "UNACKNOWLEDGED": {
                writeConcern = WriteConcern.UNACKNOWLEDGED;
                break;
            }
            case "FSYNCED": {
                writeConcern = WriteConcern.JOURNALED;
                break;
            }
            case "JOURNALED": {
                writeConcern = WriteConcern.JOURNALED;
                break;
            }
            case "REPLICA_ACKNOWLEDGED": {
                writeConcern = WriteConcern.W2;
                break;
            }
            case "MAJORITY": {
                writeConcern = WriteConcern.MAJORITY;
                break;
            }
            case "W1": {
                writeConcern = WriteConcern.W1;
                break;
            }
            case "W2": {
                writeConcern = WriteConcern.W2;
                break;
            }
            case "W3": {
                writeConcern = WriteConcern.W3;
                break;
            }
            default: {
                writeConcern = WriteConcern.ACKNOWLEDGED;
            }
        }
        return writeConcern;
    }

    static {
        ArrayList<PropertyDescriptor> _propertyDescriptors = new ArrayList<PropertyDescriptor>();
        _propertyDescriptors.addAll(descriptors);
        _propertyDescriptors.add(MODE);
        _propertyDescriptors.add(UPSERT);
        _propertyDescriptors.add(UPDATE_QUERY_KEY);
        _propertyDescriptors.add(UPDATE_QUERY);
        _propertyDescriptors.add(UPDATE_MODE);
        _propertyDescriptors.add(WRITE_CONCERN);
        _propertyDescriptors.add(CHARACTER_SET);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

