/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util.validator;

import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class InstrumentedValidator
implements Validator {
    boolean doReset = false;
    private int validateCallCount;
    private Validator mockedValidator;

    public InstrumentedValidator(Validator mockedValidator) {
        this(mockedValidator, false);
    }

    public InstrumentedValidator(Validator mockedValidator, boolean resetOnGet) {
        this.mockedValidator = mockedValidator;
        this.doReset = resetOnGet;
    }

    private InstrumentedValidator() {
    }

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ++this.validateCallCount;
        return this.mockedValidator.validate(subject, input, context);
    }

    public int getValidateCallCount() {
        int count = this.validateCallCount;
        if (this.doReset) {
            this.validateCallCount = 0;
        }
        return count;
    }

    public void resetAll() {
        this.validateCallCount = 0;
    }
}

