/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.util.List;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.util.CapturingLogger;
import org.apache.nifi.util.LogMessage;
import org.slf4j.LoggerFactory;

public class MockComponentLog
implements ComponentLog {
    private final CapturingLogger logger;
    private final Object component;

    public MockComponentLog(String componentId, Object component) {
        this.logger = new CapturingLogger(LoggerFactory.getLogger(component.getClass()));
        this.component = component;
    }

    public List<LogMessage> getTraceMessages() {
        return this.logger.getTraceMessages();
    }

    public List<LogMessage> getDebugMessages() {
        return this.logger.getDebugMessages();
    }

    public List<LogMessage> getInfoMessages() {
        return this.logger.getInfoMessages();
    }

    public List<LogMessage> getWarnMessages() {
        return this.logger.getWarnMessages();
    }

    public List<LogMessage> getErrorMessages() {
        return this.logger.getErrorMessages();
    }

    private Object[] addProcessor(Object[] originalArgs) {
        return this.prependToArgs(originalArgs, this.component);
    }

    private Object[] addProcessorAndThrowable(Object[] os, Throwable t) {
        Object[] modifiedArgs = new Object[os.length + 2];
        modifiedArgs[0] = this.component.toString();
        System.arraycopy(os, 0, modifiedArgs, 1, os.length);
        modifiedArgs[modifiedArgs.length - 1] = t.toString();
        return modifiedArgs;
    }

    private Object[] addProcessorAndThrowable(Object[] os, Throwable t, boolean appendThrowable) {
        if (!appendThrowable) {
            return this.addProcessorAndThrowable(os, t);
        }
        Object[] modifiedArgs = new Object[os.length + 3];
        modifiedArgs[0] = this.component.toString();
        System.arraycopy(os, 0, modifiedArgs, 1, os.length);
        modifiedArgs[modifiedArgs.length - 2] = t.toString();
        modifiedArgs[modifiedArgs.length - 1] = t;
        return modifiedArgs;
    }

    private Object[] prependToArgs(Object[] originalArgs, Object ... toAdd) {
        Object[] newArgs = new Object[originalArgs.length + toAdd.length];
        System.arraycopy(toAdd, 0, newArgs, 0, toAdd.length);
        System.arraycopy(originalArgs, 0, newArgs, toAdd.length, originalArgs.length);
        return newArgs;
    }

    private Object[] translateException(Object[] os) {
        if (os != null && os.length > 0 && os[os.length - 1] instanceof Throwable) {
            Object[] osCopy = new Object[os.length];
            osCopy[osCopy.length - 1] = os[os.length - 1].toString();
            System.arraycopy(os, 0, osCopy, 0, os.length - 1);
            return osCopy;
        }
        return os;
    }

    private boolean lastArgIsException(Object[] os) {
        return os != null && os.length > 0 && os[os.length - 1] instanceof Throwable;
    }

    public void warn(String msg, Throwable t) {
        this.warn("{} " + msg, new Object[]{this.component}, t);
    }

    public void warn(String msg, Object ... os) {
        if (this.lastArgIsException(os)) {
            this.warn((String)msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            msg = "{} " + (String)msg;
            os = this.addProcessor(os);
            this.logger.warn((String)msg, os);
        }
    }

    public void warn(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + (String)msg + ": {}";
        this.logger.warn((String)msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.warn("", t);
        }
    }

    public void warn(String msg) {
        msg = "{} " + (String)msg;
        this.logger.warn((String)msg, this.component);
    }

    public void trace(String msg, Throwable t) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.trace((String)msg, (Object)os, (Object)t);
    }

    public void trace(String msg, Object ... os) {
        msg = "{} " + (String)msg;
        os = this.addProcessor(os);
        this.logger.trace((String)msg, os);
    }

    public void trace(String msg) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.trace((String)msg, os);
    }

    public void trace(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + (String)msg + ": {}";
        this.logger.trace((String)msg, os);
        this.logger.trace("", t);
    }

    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    public boolean isTraceEnabled() {
        return this.logger.isTraceEnabled();
    }

    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    public void info(String msg, Throwable t) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.info((String)msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
    }

    public void info(String msg, Object ... os) {
        msg = "{} " + (String)msg;
        os = this.addProcessor(os);
        this.logger.info((String)msg, os);
    }

    public void info(String msg) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.info((String)msg, os);
    }

    public void info(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + (String)msg + ": {}";
        this.logger.info((String)msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.info("", t);
        }
    }

    public String getName() {
        return this.logger.getName();
    }

    public void error(String msg, Throwable t) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.error((String)msg, (Object)os, t);
        if (this.logger.isDebugEnabled()) {
            this.logger.error("", t);
        }
    }

    public void error(String msg, Object ... os) {
        if (this.lastArgIsException(os)) {
            this.error((String)msg, this.translateException(os), (Throwable)os[os.length - 1]);
        } else {
            os = this.addProcessor(os);
            msg = "{} " + (String)msg;
            this.logger.error((String)msg, os);
        }
    }

    public void error(String msg) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.error((String)msg, os);
    }

    public void error(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t, true);
        msg = "{} " + (String)msg + ": {}";
        this.logger.error((String)msg, os);
    }

    public void debug(String msg, Throwable t) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.debug((String)msg, (Object)os, (Object)t);
    }

    public void debug(String msg, Object ... os) {
        os = this.addProcessor(os);
        msg = "{} " + (String)msg;
        this.logger.debug((String)msg, os);
    }

    public void debug(String msg, Object[] os, Throwable t) {
        os = this.addProcessorAndThrowable(os, t);
        msg = "{} " + (String)msg + ": {}";
        this.logger.debug((String)msg, os);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("", t);
        }
    }

    public void debug(String msg) {
        msg = "{} " + (String)msg;
        Object[] os = new Object[]{this.component};
        this.logger.debug((String)msg, os);
    }
}

