/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.NodeTypeProvider;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.reporting.ReportingInitializationContext;
import org.apache.nifi.scheduling.SchedulingStrategy;
import org.apache.nifi.util.MockControllerServiceLookup;

public class MockReportingInitializationContext
extends MockControllerServiceLookup
implements ReportingInitializationContext,
ControllerServiceLookup {
    private final String identifier;
    private final String name;
    private final Map<PropertyDescriptor, String> properties = new HashMap<PropertyDescriptor, String>();
    private final ComponentLog logger;

    public MockReportingInitializationContext(String identifier, String name, ComponentLog logger) {
        this.identifier = identifier;
        this.name = name;
        this.logger = logger;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getName() {
        return this.name;
    }

    public long getSchedulingPeriod(TimeUnit timeUnit) {
        return 1L;
    }

    public void setProperty(String propertyName, String value) {
        this.setProperty(new PropertyDescriptor.Builder().name(propertyName).build(), value);
    }

    public void setProperty(PropertyDescriptor propertyName, String value) {
        this.properties.put(propertyName, value);
    }

    public void setProperties(Map<PropertyDescriptor, String> properties) {
        this.properties.clear();
        this.properties.putAll(properties);
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return this;
    }

    public NodeTypeProvider getNodeTypeProvider() {
        return null;
    }

    public String getSchedulingPeriod() {
        return "0 sec";
    }

    public SchedulingStrategy getSchedulingStrategy() {
        return SchedulingStrategy.TIMER_DRIVEN;
    }

    public ComponentLog getLogger() {
        return this.logger;
    }

    public String getKerberosServicePrincipal() {
        return null;
    }

    public File getKerberosServiceKeytab() {
        return null;
    }

    public File getKerberosConfigurationFile() {
        return null;
    }
}

