/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.metrics.reporting.reporter.service;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.ScheduledReporter;
import com.codahale.metrics.graphite.Graphite;
import com.codahale.metrics.graphite.GraphiteReporter;
import com.codahale.metrics.graphite.GraphiteSender;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.net.SocketFactory;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.DeprecationNotice;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.metrics.reporting.reporter.service.MetricReporterService;
import org.apache.nifi.processor.util.StandardValidators;

@Tags(value={"metrics", "reporting", "graphite"})
@CapabilityDescription(value="A controller service that provides metric reporters for graphite. Used by MetricsReportingTask.")
@DeprecationNotice(reason="Unmaintained and planned for removal in version 2.0")
public class GraphiteMetricReporterService
extends AbstractControllerService
implements MetricReporterService {
    public static final PropertyDescriptor HOST = new PropertyDescriptor.Builder().name("host").displayName("Host").description("The hostname of the carbon listener").required(true).addValidator(StandardValidators.URI_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor PORT = new PropertyDescriptor.Builder().name("port").displayName("Port").description("The port on which carbon listens").required(true).addValidator(StandardValidators.PORT_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor CHARSET = new PropertyDescriptor.Builder().name("charset").displayName("Charset").description("The charset used by the graphite server").required(true).defaultValue("UTF-8").addValidator(StandardValidators.CHARACTER_SET_VALIDATOR).build();
    protected static final PropertyDescriptor METRIC_NAME_PREFIX = new PropertyDescriptor.Builder().name("metric name prefix").displayName("Metric Name Prefix").description("A prefix that will be used for all metric names sent by reporters provided by this service.").required(true).defaultValue("nifi").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    private static final List<PropertyDescriptor> properties;
    private GraphiteSender graphiteSender;
    private String metricNamePrefix;

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        String host = context.getProperty(HOST).evaluateAttributeExpressions().getValue();
        int port = context.getProperty(PORT).evaluateAttributeExpressions().asInteger();
        Charset charset = Charset.forName(context.getProperty(CHARSET).getValue());
        this.graphiteSender = this.createSender(host, port, charset);
        this.metricNamePrefix = context.getProperty(METRIC_NAME_PREFIX).evaluateAttributeExpressions().getValue();
    }

    @OnDisabled
    public void shutdown() throws IOException {
        try {
            this.graphiteSender.close();
        }
        finally {
            this.graphiteSender = null;
        }
    }

    public ScheduledReporter createReporter(MetricRegistry metricRegistry) {
        return GraphiteReporter.forRegistry((MetricRegistry)metricRegistry).prefixedWith(this.metricNamePrefix).build(this.graphiteSender);
    }

    protected GraphiteSender createSender(String host, int port, Charset charset) {
        return new Graphite(host, port, SocketFactory.getDefault(), charset);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    static {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(HOST);
        props.add(PORT);
        props.add(CHARSET);
        props.add(METRIC_NAME_PREFIX);
        properties = Collections.unmodifiableList(props);
    }
}

