/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.metrics;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.controller.status.ProcessGroupStatus;
import org.apache.nifi.controller.status.ProcessorStatus;

public class FlowMetricSet
implements MetricSet {
    private final AtomicReference<ProcessGroupStatus> currentStatusReference;

    public FlowMetricSet(AtomicReference<ProcessGroupStatus> currentStatusReference) {
        this.currentStatusReference = currentStatusReference;
    }

    public Map<String, Metric> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.put("ActiveThreads", (Metric)((Gauge)() -> this.currentStatusReference.get().getActiveThreadCount()));
        metrics.put("BytesQueued", (Metric)((Gauge)() -> this.currentStatusReference.get().getQueuedContentSize()));
        metrics.put("BytesReadLast5Minutes", (Metric)((Gauge)() -> this.currentStatusReference.get().getBytesRead()));
        metrics.put("BytesReceivedLast5Minutes", (Metric)((Gauge)() -> this.currentStatusReference.get().getBytesReceived()));
        metrics.put("BytesSentLast5Minutes", (Metric)((Gauge)() -> this.currentStatusReference.get().getBytesSent()));
        metrics.put("BytesWrittenLast5Minutes", (Metric)((Gauge)() -> this.currentStatusReference.get().getBytesWritten()));
        metrics.put("FlowFilesReceivedLast5Minutes", (Metric)((Gauge)() -> this.currentStatusReference.get().getFlowFilesReceived()));
        metrics.put("FlowFilesQueued", (Metric)((Gauge)() -> this.currentStatusReference.get().getQueuedCount()));
        metrics.put("FlowFilesSentLast5Minutes", (Metric)((Gauge)() -> this.currentStatusReference.get().getFlowFilesSent()));
        metrics.put("TotalTaskDurationNanoSeconds", (Metric)((Gauge)() -> this.calculateProcessingNanos(this.currentStatusReference.get())));
        return metrics;
    }

    private long calculateProcessingNanos(ProcessGroupStatus status) {
        long nanos = 0L;
        for (ProcessorStatus procStats : status.getProcessorStatus()) {
            nanos += procStats.getProcessingNanos();
        }
        for (ProcessGroupStatus childGroupStatus : status.getProcessGroupStatus()) {
            nanos += this.calculateProcessingNanos(childGroupStatus);
        }
        return nanos;
    }
}

