/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kerberos;

import java.util.ArrayList;
import java.util.List;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;

public class MockKerberosCredentialsService
extends AbstractControllerService
implements KerberosCredentialsService {
    public static String DEFAULT_KEYTAB = "src/test/resources/fake.keytab";
    public static String DEFAULT_PRINCIPAL = "test@REALM.COM";
    private volatile String keytab = DEFAULT_KEYTAB;
    private volatile String principal = DEFAULT_PRINCIPAL;
    public static final PropertyDescriptor PRINCIPAL = new PropertyDescriptor.Builder().name("Kerberos Principal").description("Kerberos principal to authenticate as. Requires nifi.kerberos.krb5.file to be set in your nifi.properties").addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();
    public static final PropertyDescriptor KEYTAB = new PropertyDescriptor.Builder().name("Kerberos Keytab").description("Kerberos keytab associated with the principal. Requires nifi.kerberos.krb5.file to be set in your nifi.properties").identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).required(true).build();

    @OnEnabled
    public void onConfigured(ConfigurationContext context) throws InitializationException {
        this.keytab = context.getProperty(KEYTAB).getValue();
        this.principal = context.getProperty(PRINCIPAL).getValue();
    }

    public String getKeytab() {
        return this.keytab;
    }

    public String getPrincipal() {
        return this.principal;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>(2);
        properties.add(KEYTAB);
        properties.add(PRINCIPAL);
        return properties;
    }

    public String getIdentifier() {
        return "kcs";
    }
}

