/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.security.auth.login.AppConfigurationEntry;

public class LoginConfigBuilder {
    private static final Map<AppConfigurationEntry.LoginModuleControlFlag, String> CONTROL_FLAGS = new LinkedHashMap<AppConfigurationEntry.LoginModuleControlFlag, String>();
    private static final String SPACE = " ";
    private static final String EQUALS = "=";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SEMI_COLON = ";";
    private final StringBuilder builder;

    public LoginConfigBuilder(String moduleClassName, AppConfigurationEntry.LoginModuleControlFlag controlFlag) {
        String moduleControlFlag = Objects.requireNonNull(CONTROL_FLAGS.get(controlFlag), "Control Flag not found");
        this.builder = new StringBuilder(moduleClassName).append(SPACE).append(moduleControlFlag);
    }

    public LoginConfigBuilder append(String key, Object value) {
        this.builder.append(SPACE);
        this.builder.append(key);
        this.builder.append(EQUALS);
        if (value instanceof String) {
            this.builder.append(DOUBLE_QUOTE);
            this.builder.append(value);
            this.builder.append(DOUBLE_QUOTE);
        } else {
            this.builder.append(value);
        }
        return this;
    }

    public String build() {
        this.builder.append(SEMI_COLON);
        return this.builder.toString();
    }

    static {
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL, "optional");
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.REQUIRED, "required");
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.REQUISITE, "requisite");
        CONTROL_FLAGS.put(AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT, "sufficient");
    }
}

