/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.KerberosCredentialsLoginConfigProvider;
import org.apache.nifi.kafka.shared.login.KerberosUserServiceLoginConfigProvider;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;

public class KerberosDelegatingLoginConfigProvider
implements LoginConfigProvider {
    private static final LoginConfigProvider CREDENTIALS_PROVIDER = new KerberosCredentialsLoginConfigProvider();
    private static final LoginConfigProvider USER_SERVICE_PROVIDER = new KerberosUserServiceLoginConfigProvider();

    @Override
    public String getConfiguration(PropertyContext context) {
        PropertyValue userServiceProperty = context.getProperty(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE);
        String configuration = userServiceProperty.isSet() ? USER_SERVICE_PROVIDER.getConfiguration(context) : CREDENTIALS_PROVIDER.getConfiguration(context);
        return configuration;
    }
}

