/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.component;

import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.kafka.shared.property.SaslMechanism;
import org.apache.nifi.kafka.shared.property.SecurityProtocol;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.kerberos.SelfContainedKerberosUserService;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.ssl.SSLContextService;

public interface KafkaClientComponent {
    public static final PropertyDescriptor BOOTSTRAP_SERVERS = new PropertyDescriptor.Builder().name("bootstrap.servers").displayName("Kafka Brokers").description("Comma-separated list of Kafka Brokers in the format host:port").required(true).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).defaultValue("localhost:9092").build();
    public static final PropertyDescriptor SECURITY_PROTOCOL = new PropertyDescriptor.Builder().name("security.protocol").displayName("Security Protocol").description("Security protocol used to communicate with brokers. Corresponds to Kafka Client security.protocol property").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues((Enum[])SecurityProtocol.values()).defaultValue(SecurityProtocol.PLAINTEXT.name()).build();
    public static final PropertyDescriptor SASL_MECHANISM = new PropertyDescriptor.Builder().name("sasl.mechanism").displayName("SASL Mechanism").description("SASL mechanism used for authentication. Corresponds to Kafka Client sasl.mechanism property").required(true).expressionLanguageSupported(ExpressionLanguageScope.NONE).allowableValues(SaslMechanism.getAvailableSaslMechanisms()).defaultValue(SaslMechanism.GSSAPI.getValue()).build();
    public static final PropertyDescriptor SASL_USERNAME = new PropertyDescriptor.Builder().name("sasl.username").displayName("Username").description("Username provided with configured password when using PLAIN or SCRAM SASL Mechanisms").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dependsOn(SASL_MECHANISM, SaslMechanism.PLAIN.getValue(), new String[]{SaslMechanism.SCRAM_SHA_256.getValue(), SaslMechanism.SCRAM_SHA_512.getValue()}).build();
    public static final PropertyDescriptor SASL_PASSWORD = new PropertyDescriptor.Builder().name("sasl.password").displayName("Password").description("Password provided with configured username when using PLAIN or SCRAM SASL Mechanisms").required(false).sensitive(true).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).dependsOn(SASL_MECHANISM, SaslMechanism.PLAIN.getValue(), new String[]{SaslMechanism.SCRAM_SHA_256.getValue(), SaslMechanism.SCRAM_SHA_512.getValue()}).build();
    public static final PropertyDescriptor TOKEN_AUTHENTICATION = new PropertyDescriptor.Builder().name("sasl.token.auth").displayName("Token Authentication").description("Enables or disables Token authentication when using SCRAM SASL Mechanisms").required(false).allowableValues(new String[]{Boolean.TRUE.toString(), Boolean.FALSE.toString()}).defaultValue(Boolean.FALSE.toString()).dependsOn(SASL_MECHANISM, SaslMechanism.SCRAM_SHA_256.getValue(), new String[]{SaslMechanism.SCRAM_SHA_512.getValue()}).build();
    public static final PropertyDescriptor AWS_PROFILE_NAME = new PropertyDescriptor.Builder().name("aws.profile.name").displayName("AWS Profile Name").description("The Amazon Web Services Profile to select when multiple profiles are available.").dependsOn(SASL_MECHANISM, (DescribedValue)SaslMechanism.AWS_MSK_IAM, new DescribedValue[0]).required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("ssl.context.service").displayName("SSL Context Service").description("Service supporting SSL communication with Kafka brokers").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor KERBEROS_SERVICE_NAME = new PropertyDescriptor.Builder().name("sasl.kerberos.service.name").displayName("Kerberos Service Name").description("The service name that matches the primary name of the Kafka server configured in the broker JAAS configuration").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_PRINCIPAL = new PropertyDescriptor.Builder().name("sasl.kerberos.principal").displayName("Kerberos Principal").description("Principal used for authentication with Kerberos").required(false).addValidator(StandardValidators.NON_BLANK_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_KEYTAB = new PropertyDescriptor.Builder().name("sasl.kerberos.keytab").displayName("Kerberos Keytab").description("Keytab credentials used for authentication with Kerberos").required(false).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.FILE, new ResourceType[0]).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    public static final PropertyDescriptor KERBEROS_CREDENTIALS_SERVICE = new PropertyDescriptor.Builder().name("kerberos-credentials-service").displayName("Kerberos Credentials Service").description("Service supporting generalized credentials authentication with Kerberos").identifiesControllerService(KerberosCredentialsService.class).required(false).build();
    public static final PropertyDescriptor SELF_CONTAINED_KERBEROS_USER_SERVICE = new PropertyDescriptor.Builder().name("kerberos-user-service").displayName("Kerberos User Service").description("Service supporting user authentication with Kerberos").identifiesControllerService(SelfContainedKerberosUserService.class).required(false).build();
}

