/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;
import org.apache.nifi.kerberos.KerberosCredentialsService;

public class KerberosCredentialsLoginConfigProvider
implements LoginConfigProvider {
    private static final String MODULE_CLASS_NAME = "com.sun.security.auth.module.Krb5LoginModule";
    private static final String FORMAT = "%s required renewTicket=true useKeyTab=true serviceName=\"%s\" principal=\"%s\" keyTab=\"%s\";";

    @Override
    public String getConfiguration(PropertyContext context) {
        String keyTab;
        String principal;
        KerberosCredentialsService credentialsService = (KerberosCredentialsService)context.getProperty(KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
        if (credentialsService == null) {
            principal = context.getProperty(KafkaClientComponent.KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
            keyTab = context.getProperty(KafkaClientComponent.KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
        } else {
            principal = credentialsService.getPrincipal();
            keyTab = credentialsService.getKeytab();
        }
        String serviceName = context.getProperty(KafkaClientComponent.KERBEROS_SERVICE_NAME).evaluateAttributeExpressions().getValue();
        return String.format(FORMAT, MODULE_CLASS_NAME, serviceName, principal, keyTab);
    }
}

