/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.property.KafkaClientProperty;
import org.apache.nifi.kafka.shared.property.SaslMechanism;
import org.apache.nifi.kafka.shared.property.SecurityProtocol;
import org.apache.nifi.kerberos.KerberosCredentialsService;
import org.apache.nifi.kerberos.KerberosUserService;

public class KafkaClientCustomValidationFunction
implements Function<ValidationContext, Collection<ValidationResult>> {
    static final String JAVA_SECURITY_AUTH_LOGIN_CONFIG = "java.security.auth.login.config";
    private static final String ALLOW_EXPLICIT_KEYTAB = "NIFI_ALLOW_EXPLICIT_KEYTAB";
    private static final String JNDI_LOGIN_MODULE_CLASS = "JndiLoginModule";
    private static final String JND_LOGIN_MODULE_EXPLANATION = "The JndiLoginModule is not allowed in the JAAS configuration";
    private static final List<String> USERNAME_PASSWORD_SASL_MECHANISMS = Arrays.asList(SaslMechanism.PLAIN.getValue(), SaslMechanism.SCRAM_SHA_256.getValue(), SaslMechanism.SCRAM_SHA_512.getValue());
    private static final List<String> SASL_PROTOCOLS = Arrays.asList(SecurityProtocol.SASL_PLAINTEXT.name(), SecurityProtocol.SASL_SSL.name());

    @Override
    public Collection<ValidationResult> apply(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>();
        this.validateLoginModule(validationContext, results);
        this.validateKerberosServices(validationContext, results);
        this.validateKerberosCredentials(validationContext, results);
        this.validateUsernamePassword(validationContext, results);
        return results;
    }

    private void validateLoginModule(ValidationContext validationContext, Collection<ValidationResult> results) {
        PropertyDescriptor propertyDescriptor2;
        String saslJaasConfig;
        Optional<PropertyDescriptor> propertyDescriptorFound = validationContext.getProperties().keySet().stream().filter(propertyDescriptor -> KafkaClientProperty.SASL_JAAS_CONFIG.getProperty().equals(propertyDescriptor.getName())).findFirst();
        if (propertyDescriptorFound.isPresent() && (saslJaasConfig = validationContext.getProperty(propertyDescriptor2 = propertyDescriptorFound.get()).getValue()).contains(JNDI_LOGIN_MODULE_CLASS)) {
            results.add(new ValidationResult.Builder().subject(propertyDescriptor2.getName()).valid(false).explanation(JND_LOGIN_MODULE_EXPLANATION).build());
        }
    }

    private void validateKerberosServices(ValidationContext validationContext, Collection<ValidationResult> results) {
        String explanation;
        PropertyValue userServiceProperty = validationContext.getProperty(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE);
        PropertyValue credentialsServiceProperty = validationContext.getProperty(KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE);
        String principal = validationContext.getProperty(KafkaClientComponent.KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
        String keyTab = validationContext.getProperty(KafkaClientComponent.KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
        if (userServiceProperty.isSet()) {
            if (credentialsServiceProperty.isSet()) {
                explanation = String.format("Cannot configure both [%s] and [%s]", KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE.getDisplayName(), KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE.getDisplayName());
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation(explanation).build());
            }
            if (this.isNotEmpty(principal) || this.isNotEmpty(keyTab)) {
                explanation = String.format("Cannot configure [%s] with [%s] or [%s]", KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE.getDisplayName(), KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName(), KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName());
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE.getDisplayName()).valid(false).explanation(explanation).build());
            }
        } else if (credentialsServiceProperty.isSet() && (this.isNotEmpty(principal) || this.isNotEmpty(keyTab))) {
            explanation = String.format("Cannot configure [%s] with [%s] or [%s]", KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE.getDisplayName(), KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName(), KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName());
            results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE.getDisplayName()).valid(false).explanation(explanation).build());
        }
        String allowExplicitKeytab = System.getenv(ALLOW_EXPLICIT_KEYTAB);
        if (Boolean.FALSE.toString().equalsIgnoreCase(allowExplicitKeytab) && (this.isNotEmpty(principal) || this.isNotEmpty(keyTab))) {
            String explanation2 = String.format("Environment Variable [%s] disables configuring [%s] and [%s] properties", ALLOW_EXPLICIT_KEYTAB, KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName(), KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName());
            results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation(explanation2).build());
        }
    }

    private void validateKerberosCredentials(ValidationContext validationContext, Collection<ValidationResult> results) {
        String saslMechanism = validationContext.getProperty(KafkaClientComponent.SASL_MECHANISM).getValue();
        String securityProtocol = validationContext.getProperty(KafkaClientComponent.SECURITY_PROTOCOL).getValue();
        if (SaslMechanism.GSSAPI.name().equals(saslMechanism) && SASL_PROTOCOLS.contains(securityProtocol)) {
            String explanation;
            String serviceName = validationContext.getProperty(KafkaClientComponent.KERBEROS_SERVICE_NAME).evaluateAttributeExpressions().getValue();
            if (this.isEmpty(serviceName)) {
                String explanation2 = String.format("[%s] required for [%s] value [%s]", new Object[]{KafkaClientComponent.KERBEROS_SERVICE_NAME.getDisplayName(), KafkaClientComponent.SASL_MECHANISM.getDisplayName(), SaslMechanism.GSSAPI});
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_SERVICE_NAME.getDisplayName()).valid(false).explanation(explanation2).build());
            }
            String principal = validationContext.getProperty(KafkaClientComponent.KERBEROS_PRINCIPAL).evaluateAttributeExpressions().getValue();
            String keyTab = validationContext.getProperty(KafkaClientComponent.KERBEROS_KEYTAB).evaluateAttributeExpressions().getValue();
            String systemLoginConfig = System.getProperty(JAVA_SECURITY_AUTH_LOGIN_CONFIG);
            if (this.isEmpty(principal) && this.isNotEmpty(keyTab)) {
                explanation = String.format("[%s] required when configuring [%s]", KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName(), KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName());
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName()).valid(false).explanation(explanation).build());
            } else if (this.isNotEmpty(principal) && this.isEmpty(keyTab)) {
                explanation = String.format("[%s] required when configuring [%s]", KafkaClientComponent.KERBEROS_PRINCIPAL.getDisplayName(), KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName());
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.KERBEROS_KEYTAB.getDisplayName()).valid(false).explanation(explanation).build());
            }
            KerberosUserService userService = (KerberosUserService)validationContext.getProperty(KafkaClientComponent.SELF_CONTAINED_KERBEROS_USER_SERVICE).asControllerService(KerberosUserService.class);
            KerberosCredentialsService credentialsService = (KerberosCredentialsService)validationContext.getProperty(KafkaClientComponent.KERBEROS_CREDENTIALS_SERVICE).asControllerService(KerberosCredentialsService.class);
            if (userService == null && credentialsService == null && this.isEmpty(principal) && this.isEmpty(keyTab) && this.isEmpty(systemLoginConfig)) {
                String explanation3 = String.format("Kerberos Credentials not found in component properties or System Property [%s]", JAVA_SECURITY_AUTH_LOGIN_CONFIG);
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_MECHANISM.getDisplayName()).valid(false).explanation(explanation3).build());
            }
        }
    }

    private void validateUsernamePassword(ValidationContext validationContext, Collection<ValidationResult> results) {
        String saslMechanism = validationContext.getProperty(KafkaClientComponent.SASL_MECHANISM).getValue();
        if (USERNAME_PASSWORD_SASL_MECHANISMS.contains(saslMechanism)) {
            String password;
            String username = validationContext.getProperty(KafkaClientComponent.SASL_USERNAME).evaluateAttributeExpressions().getValue();
            if (username == null || username.isEmpty()) {
                String explanation = String.format("[%s] required for [%s] values: %s", KafkaClientComponent.SASL_USERNAME.getDisplayName(), KafkaClientComponent.SASL_MECHANISM.getDisplayName(), USERNAME_PASSWORD_SASL_MECHANISMS);
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_USERNAME.getDisplayName()).valid(false).explanation(explanation).build());
            }
            if ((password = validationContext.getProperty(KafkaClientComponent.SASL_PASSWORD).evaluateAttributeExpressions().getValue()) == null || password.isEmpty()) {
                String explanation = String.format("[%s] required for [%s] values: %s", KafkaClientComponent.SASL_PASSWORD.getDisplayName(), KafkaClientComponent.SASL_MECHANISM.getDisplayName(), USERNAME_PASSWORD_SASL_MECHANISMS);
                results.add(new ValidationResult.Builder().subject(KafkaClientComponent.SASL_PASSWORD.getDisplayName()).valid(false).explanation(explanation).build());
            }
        }
    }

    private boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    private boolean isNotEmpty(String string) {
        return string != null && !string.isEmpty();
    }
}

