/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.kafka.shared.login;

import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.kafka.shared.component.KafkaClientComponent;
import org.apache.nifi.kafka.shared.login.LoginConfigProvider;

public class ScramLoginConfigProvider
implements LoginConfigProvider {
    private static final String MODULE_CLASS_NAME = "org.apache.kafka.common.security.scram.ScramLoginModule";
    private static final String FORMAT = "%s required username=\"%s\" password=\"%s\"";
    private static final String TOKEN_AUTH_ENABLED = "tokenauth=true";
    private static final String SEMI_COLON = ";";

    @Override
    public String getConfiguration(PropertyContext context) {
        StringBuilder builder = new StringBuilder();
        String username = context.getProperty(KafkaClientComponent.SASL_USERNAME).evaluateAttributeExpressions().getValue();
        String password = context.getProperty(KafkaClientComponent.SASL_PASSWORD).evaluateAttributeExpressions().getValue();
        String moduleUsernamePassword = String.format(FORMAT, MODULE_CLASS_NAME, username, password);
        builder.append(moduleUsernamePassword);
        Boolean tokenAuthenticationEnabled = context.getProperty(KafkaClientComponent.TOKEN_AUTHENTICATION).asBoolean();
        if (Boolean.TRUE == tokenAuthenticationEnabled) {
            builder.append(TOKEN_AUTH_ENABLED);
        }
        builder.append(SEMI_COLON);
        return builder.toString();
    }
}

