/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processor.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Map;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;

public class JsonValidator
implements Validator {
    public static final JsonValidator INSTANCE = new JsonValidator();

    public ValidationResult validate(String subject, String input, ValidationContext context) {
        ObjectMapper mapper = new ObjectMapper();
        if (context.isExpressionLanguageSupported(subject) && context.isExpressionLanguagePresent(input)) {
            return new ValidationResult.Builder().subject(subject).input(input).explanation("Expression Language Present").valid(true).build();
        }
        try {
            Class clz = input.startsWith("[") ? List.class : Map.class;
            mapper.readValue(input, clz);
        }
        catch (Exception e) {
            return new ValidationResult.Builder().subject(subject).input(input).valid(false).explanation(subject + " is not a valid JSON representation due to " + e.getLocalizedMessage()).build();
        }
        return new ValidationResult.Builder().subject(subject).input(input).valid(true).build();
    }
}

