/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.jms.processors.ioconcept.writer.record;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.SimpleRecordSchema;
import org.apache.nifi.serialization.record.MapRecord;
import org.apache.nifi.serialization.record.Record;
import org.apache.nifi.serialization.record.RecordField;
import org.apache.nifi.serialization.record.RecordFieldType;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.util.Tuple;

public class RecordUtils {
    public static Record append(Record originalRecord, Map<String, String> decoratorValues, String decoratorPrefix) {
        List originalFields = originalRecord.getSchema().getFields();
        ArrayList mergedFields = new ArrayList(originalFields);
        decoratorValues.forEach((key, value) -> mergedFields.add(new RecordField(decoratorPrefix + key, RecordFieldType.STRING.getDataType())));
        SimpleRecordSchema mergedSchema = new SimpleRecordSchema(mergedFields);
        HashMap recordValues = new HashMap();
        originalFields.stream().map(RecordField::getFieldName).forEach(fieldName -> recordValues.put(fieldName, originalRecord.getValue(fieldName)));
        decoratorValues.forEach((key, value) -> recordValues.put(decoratorPrefix + key, value));
        return new MapRecord((RecordSchema)mergedSchema, recordValues);
    }

    public static MapRecord wrap(Record originalRecord, String originalRecordKey, Map<String, String> decoratorValues, String decoratorKey) throws IOException, MalformedRecordException {
        Tuple<RecordField, Object> originalRecordLeaf = RecordUtils.wrapStandardRecord(originalRecord, originalRecordKey);
        Tuple<RecordField, Object> decoratorLeaf = RecordUtils.wrapDecoratorValues(decoratorValues, decoratorKey);
        SimpleRecordSchema rootRecordSchema = new SimpleRecordSchema(Arrays.asList((RecordField)originalRecordLeaf.getKey(), (RecordField)decoratorLeaf.getKey()));
        HashMap<String, Object> recordValues = new HashMap<String, Object>();
        recordValues.put(((RecordField)originalRecordLeaf.getKey()).getFieldName(), originalRecordLeaf.getValue());
        recordValues.put(((RecordField)decoratorLeaf.getKey()).getFieldName(), decoratorLeaf.getValue());
        return new MapRecord((RecordSchema)rootRecordSchema, recordValues);
    }

    private static Tuple<RecordField, Object> wrapStandardRecord(Record record, String recordKey) {
        RecordSchema recordSchema = record == null ? null : record.getSchema();
        RecordField recordField = new RecordField(recordKey, RecordFieldType.RECORD.getRecordDataType(recordSchema));
        return new Tuple((Object)recordField, (Object)record);
    }

    private static Tuple<RecordField, Object> wrapDecoratorValues(Map<String, String> decoratorValues, String decoratorKey) {
        RecordField recordField = new RecordField(decoratorKey, RecordFieldType.MAP.getMapDataType(RecordFieldType.STRING.getDataType()));
        return new Tuple((Object)recordField, decoratorValues);
    }
}

